/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.service;

import com.handy.playertitle.entity.TitleCoin;
import com.handy.playertitle.lib.db.Db;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;

public class TitleCoinService {
    private TitleCoinService() {
    }

    public static TitleCoinService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(String playerName) {
        if (this.findByPlayerName(playerName).isPresent()) {
            return true;
        }
        TitleCoin titleCoin = new TitleCoin();
        titleCoin.setPlayerName(playerName);
        titleCoin.setAmount(0);
        return Db.use(TitleCoin.class).execution().insert(titleCoin) > 0;
    }

    public Optional<TitleCoin> findByPlayerName(String playerName) {
        Db<TitleCoin> use = Db.use(TitleCoin.class);
        use.where().eq(TitleCoin::getPlayerName, playerName);
        return use.execution().selectOne();
    }

    public boolean give(String playerName, Integer amount) {
        boolean addRst = this.add(playerName);
        if (!addRst) {
            return false;
        }
        Db<TitleCoin> use = Db.use(TitleCoin.class);
        use.update().add(TitleCoin::getAmount, TitleCoin::getAmount, amount);
        use.where().eq(TitleCoin::getPlayerName, playerName);
        return use.execution().update() > 0;
    }

    public boolean set(String playerName, Integer amount) {
        boolean addRst = this.add(playerName);
        if (!addRst) {
            return false;
        }
        Db<TitleCoin> use = Db.use(TitleCoin.class);
        use.update().set(TitleCoin::getAmount, amount);
        use.where().eq(TitleCoin::getPlayerName, playerName);
        return use.execution().update() > 0;
    }

    public boolean take(String playerName, Integer amount) {
        Db<TitleCoin> use = Db.use(TitleCoin.class);
        use.update().subtract(TitleCoin::getAmount, TitleCoin::getAmount, amount);
        use.where().eq(TitleCoin::getPlayerName, playerName);
        return use.execution().update() > 0;
    }

    public void updatePlayerName(Player player) {
        Db<TitleCoin> use = Db.use(TitleCoin.class);
        use.update().set(TitleCoin::getPlayerName, player.getName()).set(TitleCoin::getPlayerUuid, player.getUniqueId().toString());
        use.where().eq(TitleCoin::getPlayerName, player.getName().toLowerCase()).isNull(TitleCoin::getPlayerUuid);
        use.execution().update();
    }

    public List<TitleCoin> findAll() {
        return Db.use(TitleCoin.class).execution().list();
    }

    public void removeAll() {
        Db.use(TitleCoin.class).execution().delete();
    }

    private static class SingletonHolder {
        private static final TitleCoinService INSTANCE = new TitleCoinService();

        private SingletonHolder() {
        }
    }
}

