/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.service;

import com.handy.playertitle.entity.TitleRewardLog;
import com.handy.playertitle.lib.db.Db;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;

public class TitleRewardLogService {
    private TitleRewardLogService() {
    }

    public static TitleRewardLogService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(TitleRewardLog titleRewardLog) {
        Db.use(TitleRewardLog.class).execution().insert(titleRewardLog);
    }

    public Optional<TitleRewardLog> findByPlayerName(String playerName) {
        Db<TitleRewardLog> use = Db.use(TitleRewardLog.class);
        use.where().eq(TitleRewardLog::getPlayerName, playerName);
        return use.execution().selectOne();
    }

    public void updateRewardType(String playerName, String rewardIds) {
        Db<TitleRewardLog> use = Db.use(TitleRewardLog.class);
        use.update().set(TitleRewardLog::getRewardIds, rewardIds);
        use.where().eq(TitleRewardLog::getPlayerName, playerName);
        use.execution().update();
    }

    public void updatePlayerName(Player player) {
        Db<TitleRewardLog> use = Db.use(TitleRewardLog.class);
        use.update().set(TitleRewardLog::getPlayerName, player.getName()).set(TitleRewardLog::getPlayerUuid, player.getUniqueId().toString());
        use.where().eq(TitleRewardLog::getPlayerName, player.getName().toLowerCase()).isNull(TitleRewardLog::getPlayerUuid);
        use.execution().update();
    }

    public List<TitleRewardLog> findAll() {
        return Db.use(TitleRewardLog.class).execution().list();
    }

    public void removeAll() {
        Db.use(TitleRewardLog.class).execution().delete();
    }

    private static class SingletonHolder {
        private static final TitleRewardLogService INSTANCE = new TitleRewardLogService();

        private SingletonHolder() {
        }
    }
}

