/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database.logger;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.Locale;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.database.statement.BlockStatement;
import net.coreprotect.database.statement.UserStatement;
import net.coreprotect.event.CoreProtectPreLogEvent;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.utility.Util;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;

public class BlockPlaceLogger {
    private BlockPlaceLogger() {
        throw new IllegalStateException("Database class");
    }

    public static void log(PreparedStatement preparedStmt, int batchCount, String user, BlockState block, int replacedType, int replacedData, Material forceType, int forceData, boolean force, List<Object> meta, String blockData, String replaceBlockData) {
        try {
            if (user == null || ConfigHandler.blacklist.get(user.toLowerCase(Locale.ROOT)) != null) {
                return;
            }
            Material type = block.getType();
            if (blockData == null && (forceType == null || !forceType.equals((Object)Material.WATER) && !forceType.equals((Object)Material.LAVA)) && (blockData = block.getBlockData().getAsString()).equals("minecraft:air")) {
                blockData = null;
            }
            int data = 0;
            if (forceType != null && force) {
                type = forceType;
                if (BukkitAdapter.ADAPTER.isItemFrame(type) || type.equals((Object)Material.SPAWNER) || type.equals((Object)Material.PAINTING) || type.equals((Object)Material.SKELETON_SKULL) || type.equals((Object)Material.SKELETON_WALL_SKULL) || type.equals((Object)Material.WITHER_SKELETON_SKULL) || type.equals((Object)Material.WITHER_SKELETON_WALL_SKULL) || type.equals((Object)Material.ZOMBIE_HEAD) || type.equals((Object)Material.ZOMBIE_WALL_HEAD) || type.equals((Object)Material.PLAYER_HEAD) || type.equals((Object)Material.PLAYER_WALL_HEAD) || type.equals((Object)Material.CREEPER_HEAD) || type.equals((Object)Material.CREEPER_WALL_HEAD) || type.equals((Object)Material.DRAGON_HEAD) || type.equals((Object)Material.DRAGON_WALL_HEAD) || type.equals((Object)Material.ARMOR_STAND) || type.equals((Object)Material.END_CRYSTAL)) {
                    data = forceData;
                } else if (user.startsWith("#")) {
                    data = forceData;
                }
            } else if (forceType != null && !type.equals((Object)forceType)) {
                type = forceType;
                data = forceData;
            }
            if (type.equals((Object)Material.AIR) || type.equals((Object)Material.CAVE_AIR)) {
                return;
            }
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            long chunkKey = (long)(x >> 4) & 0xFFFFFFFFL | ((long)(z >> 4) & 0xFFFFFFFFL) << 32;
            if (ConfigHandler.populatedChunks.get(chunkKey) != null) {
                boolean isWater = user.equals("#water");
                boolean isLava = user.equals("#lava");
                boolean isVine = user.equals("#vine");
                if (isWater || isLava || isVine) {
                    int timeDelay = isWater ? 60 : 240;
                    long timeSincePopulation = System.currentTimeMillis() / 1000L - ConfigHandler.populatedChunks.getOrDefault(chunkKey, 0L);
                    if (timeSincePopulation <= (long)timeDelay) {
                        return;
                    }
                    if (timeSincePopulation > 240L) {
                        ConfigHandler.populatedChunks.remove(chunkKey);
                    }
                } else if (type == Material.WATER || type == Material.LAVA) {
                    ConfigHandler.populatedChunks.remove(chunkKey);
                }
            }
            CoreProtectPreLogEvent event = new CoreProtectPreLogEvent(user);
            if (Config.getGlobal().API_ENABLED) {
                CoreProtect.getInstance().getServer().getPluginManager().callEvent((Event)event);
            }
            int userId = UserStatement.getId(preparedStmt, event.getUser(), true);
            int wid = Util.getWorldId(block.getWorld().getName());
            int time = (int)(System.currentTimeMillis() / 1000L);
            if (event.getUser().length() > 0) {
                CacheHandler.lookupCache.put(x + "." + y + "." + z + "." + wid, new Object[]{time, event.getUser(), type});
            }
            if (event.isCancelled()) {
                return;
            }
            int internalType = Util.getBlockId(type.name(), true);
            if (replacedType > 0 && Util.getType(replacedType) != Material.AIR && Util.getType(replacedType) != Material.CAVE_AIR) {
                BlockStatement.insert(preparedStmt, batchCount, time, userId, wid, x, y, z, replacedType, replacedData, null, replaceBlockData, 0, 0);
            }
            BlockStatement.insert(preparedStmt, batchCount, time, userId, wid, x, y, z, internalType, data, meta, blockData, 1, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

