/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.block;

import net.coreprotect.config.Config;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Lookup;
import net.coreprotect.listener.block.BlockUtil;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.utility.Util;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;

public final class BlockFromToListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockFromTo(BlockFromToEvent event) {
        Block block = event.getBlock();
        Material type = block.getType();
        if (!event.isCancelled()) {
            Waterlogged waterlogged;
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Waterlogged && (waterlogged = (Waterlogged)blockData).isWaterlogged()) {
                type = Material.WATER;
                blockData = type.createBlockData();
            }
            World world = event.getBlock().getWorld();
            if (Config.getConfig((World)world).WATER_FLOW && type.equals((Object)Material.WATER) || Config.getConfig((World)world).LAVA_FLOW && type.equals((Object)Material.LAVA)) {
                String p;
                Block toBlock = event.getToBlock();
                BlockState toBlockState = toBlock.getState();
                if (blockData instanceof Levelled) {
                    Levelled levelled = (Levelled)blockData;
                    int waterLevel = levelled.getLevel() + 1;
                    if (waterLevel > 8) {
                        waterLevel -= 8;
                    }
                    levelled.setLevel(waterLevel);
                    blockData = levelled;
                }
                if (toBlock.getBlockData() instanceof Waterlogged || toBlock.isEmpty()) {
                    toBlockState = null;
                }
                String f = "#flow";
                if (type.equals((Object)Material.WATER)) {
                    f = "#water";
                } else if (type.equals((Object)Material.LAVA)) {
                    f = "#lava";
                }
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                int x = toBlock.getX();
                int y = toBlock.getY();
                int z = toBlock.getZ();
                int wid = Util.getWorldId(block.getWorld().getName());
                if (Config.getConfig((World)world).LIQUID_TRACKING && (p = Lookup.whoPlacedCache(block)).length() > 0) {
                    f = p;
                }
                if (f.startsWith("#")) {
                    Location location = toBlock.getLocation();
                    int timestamp = (int)(System.currentTimeMillis() / 1000L);
                    Object[] cacheData = CacheHandler.spreadCache.get(location);
                    CacheHandler.spreadCache.put(location, new Object[]{timestamp, type});
                    if (toBlockState == null && cacheData != null && (Material)cacheData[1] == type) {
                        return;
                    }
                }
                CacheHandler.lookupCache.put(x + "." + y + "." + z + "." + wid, new Object[]{unixtimestamp, f, type});
                Queue.queueBlockPlace(f, toBlock.getState(), block.getType(), toBlockState, type, -1, 0, blockData.getAsString());
            } else if (type.equals((Object)Material.DRAGON_EGG)) {
                Location location = block.getLocation();
                int worldId = Util.getWorldId(location.getWorld().getName());
                int x = location.getBlockX();
                int y = location.getBlockY();
                int z = location.getBlockZ();
                String coordinates = x + "." + y + "." + z + "." + worldId + "." + type.name();
                String user = "#entity";
                Object[] data = CacheHandler.interactCache.get(coordinates);
                if (data != null && data[1] == Material.DRAGON_EGG) {
                    long oldTime;
                    long newTime = System.currentTimeMillis();
                    if (newTime - (oldTime = ((Long)data[0]).longValue()) < 20L) {
                        user = (String)data[2];
                    }
                    CacheHandler.interactCache.remove(coordinates);
                }
                if (Config.getConfig((World)block.getWorld()).BLOCK_BREAK) {
                    Queue.queueBlockBreak(user, block.getState(), block.getType(), block.getBlockData().getAsString(), 0);
                }
                if (Config.getConfig((World)block.getWorld()).BLOCK_PLACE) {
                    Block toBlock = event.getToBlock();
                    BlockState toBlockState = toBlock.getState();
                    if (Config.getConfig((World)world).BLOCK_MOVEMENT) {
                        toBlockState = BlockUtil.gravityScan(toBlock.getLocation(), type, user).getState();
                    }
                    Queue.queueBlockPlace(user, toBlockState, block.getType(), toBlockState, type, -1, 0, blockData.getAsString());
                }
            }
        }
    }
}

