/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility;

import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Rollback;
import net.coreprotect.language.Phrase;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.serialize.ItemMetaHandler;
import net.coreprotect.worldedit.CoreProtectEditSessionEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.Jukebox;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class Util
extends Queue {
    public static final java.util.regex.Pattern tagParser = java.util.regex.Pattern.compile("<COMPONENT>(.+?)</COMPONENT>|(.+?)", 32);
    private static final String NAMESPACE = "minecraft:";

    private Util() {
        throw new IllegalStateException("Utility class");
    }

    public static String getPluginVersion() {
        String version = CoreProtect.getInstance().getDescription().getVersion();
        if (version.contains("-")) {
            version = version.split("-")[0];
        }
        return version;
    }

    public static Integer[] getInternalPluginVersion() {
        int major = 2;
        int minor = 0;
        int revision = 0;
        String pluginVersion = Util.getPluginVersion();
        if (pluginVersion.contains(".")) {
            String[] versionSplit = pluginVersion.split("\\.");
            minor = Integer.parseInt(versionSplit[0]);
            revision = Integer.parseInt(versionSplit[1]);
        } else {
            minor = Integer.parseInt(pluginVersion);
        }
        return new Integer[]{major, minor, revision};
    }

    public static String getPluginName() {
        Object name = CoreProtect.getInstance().getDescription().getName();
        String branch = ConfigHandler.EDITION_BRANCH;
        if (branch.startsWith("-edge")) {
            name = (String)name + " " + branch.substring(1, 2).toUpperCase() + branch.substring(2, 5);
        }
        return name;
    }

    public static int getBlockId(Material material) {
        if (material == null) {
            material = Material.AIR;
        }
        return Util.getBlockId(material.name(), true);
    }

    public static String getCoordinates(String command, int worldId, int x, int y, int z, boolean displayWorld, boolean italic) {
        StringBuilder message = new StringBuilder("<COMPONENT>COMMAND");
        StringBuilder worldDisplay = new StringBuilder();
        if (displayWorld) {
            worldDisplay.append("/" + Util.getWorldName(worldId));
        }
        message.append("|/" + command + " teleport wid:" + worldId + " " + ((double)x + 0.5) + " " + y + " " + ((double)z + 0.5) + "|");
        message.append(Color.GREY + (italic ? "\u00a7o" : "") + "(x" + x + "/y" + y + "/z" + z + worldDisplay.toString() + ")");
        return message.append("</COMPONENT>").toString();
    }

    public static String getPageNavigation(String command, int page, int totalPages) {
        StringBuilder message = new StringBuilder();
        Object backArrow = "";
        if (page > 1) {
            backArrow = "\u25c0 ";
            backArrow = "<COMPONENT>COMMAND|/" + command + " l " + (page - 1) + "|" + (String)backArrow + "</COMPONENT>";
        }
        Object nextArrow = " ";
        if (page < totalPages) {
            nextArrow = " \u25b6 ";
            nextArrow = "<COMPONENT>COMMAND|/" + command + " l " + (page + 1) + "|" + (String)nextArrow + "</COMPONENT>";
        }
        StringBuilder pagination = new StringBuilder();
        if (totalPages > 1) {
            int displayEnd;
            pagination.append(Color.GREY + "(");
            if (page > 3) {
                pagination.append(Color.WHITE + "<COMPONENT>COMMAND|/" + command + " l 1|1 </COMPONENT>");
                if (page > 4 && totalPages > 7) {
                    pagination.append(Color.GREY + "... ");
                } else {
                    pagination.append(Color.GREY + "| ");
                }
            }
            int displayStart = page - 2 < 1 ? 1 : page - 2;
            int n = displayEnd = page + 2 > totalPages ? totalPages : page + 2;
            if (page > 999 || page > 101 && totalPages > 99999) {
                displayStart = displayStart + 1 < displayEnd ? displayStart + 1 : displayStart;
                int n2 = displayEnd = displayEnd - 1 > displayStart ? displayEnd - 1 : displayEnd;
                if (displayStart > totalPages - 3) {
                    displayStart = totalPages - 3 < 1 ? 1 : totalPages - 3;
                }
            } else {
                if (displayStart > totalPages - 5) {
                    int n3 = displayStart = totalPages - 5 < 1 ? 1 : totalPages - 5;
                }
                if (displayEnd < 6) {
                    int n4 = displayEnd = 6 > totalPages ? totalPages : 6;
                }
            }
            if (page > 99999) {
                displayStart = displayStart + 1 < displayEnd ? displayStart + 1 : displayStart;
                int n5 = displayEnd = displayEnd - 1 >= displayStart ? displayEnd - 1 : displayEnd;
                if (page == totalPages - 1) {
                    displayEnd = totalPages - 1;
                }
                if (displayStart < displayEnd) {
                    displayStart = displayEnd;
                }
            }
            if (page > 3 && displayStart == 1) {
                displayStart = 2;
            }
            for (int displayPage = displayStart; displayPage <= displayEnd; ++displayPage) {
                if (page != displayPage) {
                    pagination.append(Color.WHITE + "<COMPONENT>COMMAND|/" + command + " l " + displayPage + "|" + displayPage + (displayPage < totalPages ? " " : "") + "</COMPONENT>");
                } else {
                    pagination.append(Color.WHITE + "\u00a7n" + displayPage + "\u00a7r" + (displayPage < totalPages ? " " : ""));
                }
                if (displayPage >= displayEnd) continue;
                pagination.append(Color.GREY + "| ");
            }
            if (displayEnd < totalPages) {
                if (displayEnd < totalPages - 1) {
                    pagination.append(Color.GREY + "... ");
                } else {
                    pagination.append(Color.GREY + "| ");
                }
                if (page != totalPages) {
                    pagination.append(Color.WHITE + "<COMPONENT>COMMAND|/" + command + " l " + totalPages + "|" + totalPages + "</COMPONENT>");
                } else {
                    pagination.append(Color.WHITE + "\u00a7n" + totalPages);
                }
            }
            pagination.append(Color.GREY + ")");
        }
        return message.append(Color.WHITE + (String)backArrow + Color.DARK_AQUA + Phrase.build(Phrase.LOOKUP_PAGE, Color.WHITE + page + "/" + totalPages) + (String)nextArrow + pagination).toString();
    }

    public static String getTimeSince(long resultTime, long currentTime, boolean component) {
        StringBuilder message = new StringBuilder();
        double timeSince = (double)currentTime - ((double)resultTime + 0.0);
        if (timeSince < 0.0) {
            timeSince = 0.0;
        }
        if ((timeSince /= 60.0) < 60.0) {
            message.append(Phrase.build(Phrase.LOOKUP_TIME, new DecimalFormat("0.00").format(timeSince) + "/m"));
        }
        if (message.length() == 0 && (timeSince /= 60.0) < 24.0) {
            message.append(Phrase.build(Phrase.LOOKUP_TIME, new DecimalFormat("0.00").format(timeSince) + "/h"));
        }
        if (message.length() == 0) {
            message.append(Phrase.build(Phrase.LOOKUP_TIME, new DecimalFormat("0.00").format(timeSince /= 24.0) + "/d"));
        }
        if (component) {
            Date logDate = new Date(resultTime * 1000L);
            String formattedTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(logDate);
            return "<COMPONENT>POPUP|" + Color.GREY + formattedTimestamp + "|" + Color.GREY + message.toString() + "</COMPONENT>";
        }
        return message.toString();
    }

    public static String getEnchantments(byte[] metadata, int type, int amount) {
        if (metadata == null) {
            return "";
        }
        ItemStack item = new ItemStack(Util.getType(type), amount);
        String displayName = (item = (ItemStack)Rollback.populateItemStack(item, metadata)[2]).hasItemMeta() && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : "";
        StringBuilder message = new StringBuilder("\u00a7o" + displayName + Color.GREY);
        List<String> enchantments = ItemMetaHandler.getEnchantments(item, displayName);
        for (String enchantment : enchantments) {
            if (message.length() > 0) {
                message.append("\n");
            }
            message.append(enchantment);
        }
        if (!displayName.isEmpty()) {
            message.insert(0, enchantments.isEmpty() ? Color.WHITE : Color.AQUA);
        } else if (!enchantments.isEmpty()) {
            String name = Util.capitalize(item.getType().name().replace("_", " "), true);
            message.insert(0, Color.AQUA + "\u00a7o" + name);
        }
        return message.toString();
    }

    public static String createTooltip(String phrase, String tooltip) {
        if (tooltip.isEmpty()) {
            return phrase;
        }
        StringBuilder message = new StringBuilder("<COMPONENT>POPUP");
        message.append("|" + tooltip.replace("|", "<PIPE/>") + "|");
        message.append(phrase);
        return message.append("</COMPONENT>").toString();
    }

    public static String hoverCommandFilter(String string) {
        StringBuilder command = new StringBuilder();
        String[] data = string.toLowerCase().split(" ");
        if (data.length > 2) {
            String nameWid;
            if (data[1].equals("l")) {
                data[1] = "page";
            }
            if (data[2].startsWith("wid:") && (nameWid = data[2].replaceFirst("wid:", "")).length() > 0 && nameWid.equals(nameWid.replaceAll("[^0-9]", "")) && (nameWid = Util.getWorldName(Integer.parseInt(nameWid))).length() > 0) {
                data[2] = nameWid;
            }
            if (data[1].equals("teleport") && data.length > 5) {
                data[3] = Integer.toString((int)(Double.parseDouble(data[3]) - 0.5));
                data[4] = Integer.toString(Integer.parseInt(data[4]));
                data[5] = Integer.toString((int)(Double.parseDouble(data[5]) - 0.5));
            }
        }
        for (String s : data) {
            if (s.isEmpty()) continue;
            if (command.length() > 0) {
                command.append(" ");
            }
            command.append(s);
        }
        return command.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String capitalize(String string, boolean allWords) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        if (string.length() <= 1) {
            return string.toUpperCase(Locale.ROOT);
        }
        string = string.toLowerCase(Locale.ROOT);
        if (allWords) {
            StringBuilder builder = new StringBuilder();
            for (String string2 : string.split(" ")) {
                void var6_6;
                if (string2.length() >= 3 && !string2.equals("and") && !string2.equals("the")) {
                    String string3 = string2.substring(0, 1).toUpperCase(Locale.ROOT) + string2.substring(1);
                }
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append((String)var6_6);
            }
            return builder.toString();
        }
        return string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }

    public static int getBlockId(String name, boolean internal) {
        int id = -1;
        if (!((String)(name = ((String)name).toLowerCase(Locale.ROOT).trim())).contains(":")) {
            name = NAMESPACE + (String)name;
        }
        if (ConfigHandler.materials.get(name) != null) {
            id = ConfigHandler.materials.get(name);
        } else if (internal) {
            int mid = ConfigHandler.materialId + 1;
            ConfigHandler.materials.put((String)name, mid);
            ConfigHandler.materialsReversed.put(mid, (String)name);
            ConfigHandler.materialId = mid;
            Queue.queueMaterialInsert(mid, (String)name);
            id = ConfigHandler.materials.get(name);
        }
        return id;
    }

    public static int getBlockdataId(String data, boolean internal) {
        int id = -1;
        if (ConfigHandler.blockdata.get(data = data.toLowerCase(Locale.ROOT).trim()) != null) {
            id = ConfigHandler.blockdata.get(data);
        } else if (internal) {
            int bid = ConfigHandler.blockdataId + 1;
            ConfigHandler.blockdata.put(data, bid);
            ConfigHandler.blockdataReversed.put(bid, data);
            ConfigHandler.blockdataId = bid;
            Queue.queueBlockDataInsert(bid, data);
            id = ConfigHandler.blockdata.get(data);
        }
        return id;
    }

    public static String getBlockDataString(int id) {
        String blockdata = "";
        if (ConfigHandler.blockdataReversed.get(id) != null) {
            blockdata = ConfigHandler.blockdataReversed.get(id);
        }
        return blockdata;
    }

    public static String getBlockName(int id) {
        String name = "";
        if (ConfigHandler.materialsReversed.get(id) != null) {
            name = ConfigHandler.materialsReversed.get(id);
        }
        return name;
    }

    public static String getBlockNameShort(int id) {
        String name = Util.getBlockName(id);
        if (name.contains(":")) {
            name = name.split(":")[1];
        }
        return name;
    }

    public static void mergeItems(Material material, ItemStack[] items) {
        if (material != null && (material.equals((Object)Material.ARMOR_STAND) || BukkitAdapter.ADAPTER.isItemFrame(material))) {
            return;
        }
        try {
            int c1 = 0;
            for (ItemStack o1 : items) {
                if (o1 != null && o1.getAmount() > 0) {
                    int c2 = 0;
                    for (ItemStack o2 : items) {
                        if (o2 != null && c2 > c1 && o1.isSimilar(o2) && !Util.isAir(o1.getType())) {
                            int namount = o1.getAmount() + o2.getAmount();
                            o1.setAmount(namount);
                            o2.setAmount(0);
                        }
                        ++c2;
                    }
                }
                ++c1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Integer[] convertArray(String[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String item : array) {
            list.add(Integer.parseInt(item));
        }
        return list.toArray(new Integer[list.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] stringToByteData(String string, int type) {
        byte[] result = null;
        if (string == null) return result;
        Material material = Util.getType(type);
        if (material == null) {
            return result;
        }
        if (material.isBlock() && !Util.createBlockData(material).getAsString().equals(string) && string.startsWith(NAMESPACE + material.name().toLowerCase(Locale.ROOT) + "[") && string.endsWith("]")) {
            String substring = string.substring(material.name().length() + 11, string.length() - 1);
            String[] blockDataSplit = substring.split(",");
            ArrayList<String> blockDataArray = new ArrayList<String>();
            for (String data : blockDataSplit) {
                int id = Util.getBlockdataId(data, true);
                if (id <= -1) continue;
                blockDataArray.add(Integer.toString(id));
            }
            string = String.join((CharSequence)",", blockDataArray);
            return string.getBytes(StandardCharsets.UTF_8);
        } else {
            int id;
            if (string.contains(":")) return result;
            if (material != Material.PAINTING) {
                if (!BukkitAdapter.ADAPTER.isItemFrame(material)) return result;
            }
            if ((id = Util.getBlockdataId(string, true)) <= -1) return result;
            string = Integer.toString(id);
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String byteDataToString(byte[] data, int type) {
        Object result = "";
        if (data != null) {
            Material material = Util.getType(type);
            if (material == null) {
                return result;
            }
            result = new String(data, StandardCharsets.UTF_8);
            if (((String)result).length() > 0) {
                if (((String)result).matches("\\d+")) {
                    result = (String)result + ",";
                }
                if (((String)result).contains(",")) {
                    String[] blockDataSplit = ((String)result).split(",");
                    ArrayList<String> blockDataArray = new ArrayList<String>();
                    for (String blockData : blockDataSplit) {
                        String block = Util.getBlockDataString(Integer.parseInt(blockData));
                        if (block.length() <= 0) continue;
                        blockDataArray.add(block);
                    }
                    result = material == Material.PAINTING || BukkitAdapter.ADAPTER.isItemFrame(material) ? String.join((CharSequence)",", blockDataArray) : NAMESPACE + material.name().toLowerCase(Locale.ROOT) + "[" + String.join((CharSequence)",", blockDataArray) + "]";
                } else {
                    result = "";
                }
            }
        }
        return result;
    }

    public static byte[] convertByteData(Object data) {
        byte[] result = null;
        if (data == null) {
            return result;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BukkitObjectOutputStream oos = new BukkitObjectOutputStream((OutputStream)bos);
            oos.writeObject(data);
            oos.flush();
            oos.close();
            bos.close();
            result = bos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ItemMeta deserializeItemMeta(Class<? extends ItemMeta> itemMetaClass, Map<String, Object> args) {
        DelegateDeserialization delegate = itemMetaClass.getAnnotation(DelegateDeserialization.class);
        return (ItemMeta)ConfigurationSerialization.deserializeObject(args, (Class)delegate.value());
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>((e1, e2) -> {
            int res = ((Comparable)e1.getValue()).compareTo(e2.getValue());
            return res != 0 ? res : 1;
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public static Waterlogged checkWaterlogged(BlockData blockData, BlockState blockReplacedState) {
        if (blockReplacedState.getType().equals((Object)Material.WATER) && blockData instanceof Waterlogged && blockReplacedState.getBlockData().equals(Material.WATER.createBlockData())) {
            Waterlogged waterlogged = (Waterlogged)blockData;
            waterlogged.setWaterlogged(true);
            return waterlogged;
        }
        return null;
    }

    public static ItemStack[] getContainerState(ItemStack[] array) {
        ItemStack[] result;
        ItemStack[] itemStackArray = result = array == null ? null : (ItemStack[])array.clone();
        if (result == null) {
            return result;
        }
        int count = 0;
        for (ItemStack itemStack : array) {
            ItemStack clonedItem = null;
            if (itemStack != null) {
                clonedItem = itemStack.clone();
            }
            result[count] = clonedItem;
            ++count;
        }
        return result;
    }

    public static boolean compareContainers(ItemStack[] oldContainer, ItemStack[] newContainer) {
        if (oldContainer.length != newContainer.length) {
            return false;
        }
        for (int i = 0; i < oldContainer.length; ++i) {
            ItemStack oldItem = oldContainer[i];
            ItemStack newItem = newContainer[i];
            if (oldItem == null && newItem == null || oldItem != null && oldItem.equals((Object)newItem)) continue;
            return false;
        }
        return true;
    }

    public static boolean addedContainer(ItemStack[] oldContainer, ItemStack[] newContainer) {
        if (oldContainer.length != newContainer.length) {
            return false;
        }
        for (int i = 0; i < oldContainer.length; ++i) {
            ItemStack oldItem = oldContainer[i];
            ItemStack newItem = newContainer[i];
            if (oldItem == null && newItem == null) continue;
            if (oldItem != null && newItem == null) {
                return false;
            }
            if (oldItem == null) {
                return true;
            }
            if (newItem.equals((Object)oldItem)) continue;
            return newItem.isSimilar(oldItem) && newItem.getAmount() > oldItem.getAmount();
        }
        return false;
    }

    public static int getArtId(String name, boolean internal) {
        int id = -1;
        if (ConfigHandler.art.get(name = name.toLowerCase(Locale.ROOT).trim()) != null) {
            id = ConfigHandler.art.get(name);
        } else if (internal) {
            int artID = ConfigHandler.artId + 1;
            ConfigHandler.art.put(name, artID);
            ConfigHandler.artReversed.put(artID, name);
            ConfigHandler.artId = artID;
            Queue.queueArtInsert(artID, name);
            id = ConfigHandler.art.get(name);
        }
        return id;
    }

    public static String getArtName(int id) {
        String artname = "";
        if (ConfigHandler.artReversed.get(id) != null) {
            artname = ConfigHandler.artReversed.get(id);
        }
        return artname;
    }

    public static int setPlayerArmor(PlayerInventory inventory, ItemStack itemStack) {
        String itemName = itemStack.getType().name();
        boolean isHelmet = itemName.endsWith("_HELMET") || itemName.endsWith("_HEAD") || itemName.endsWith("_SKULL") || itemName.endsWith("_PUMPKIN");
        boolean isChestplate = itemName.endsWith("_CHESTPLATE");
        boolean isLeggings = itemName.endsWith("_LEGGINGS");
        boolean isBoots = itemName.endsWith("_BOOTS");
        if (isHelmet && inventory.getHelmet() == null) {
            inventory.setHelmet(itemStack);
            return 3;
        }
        if (isChestplate && inventory.getChestplate() == null) {
            inventory.setChestplate(itemStack);
            return 2;
        }
        if (isLeggings && inventory.getLeggings() == null) {
            inventory.setLeggings(itemStack);
            return 1;
        }
        if (isBoots && inventory.getBoots() == null) {
            inventory.setBoots(itemStack);
            return 0;
        }
        return -1;
    }

    public static ItemStack[] getArmorStandContents(EntityEquipment equipment) {
        Object[] contents = new ItemStack[6];
        if (equipment != null) {
            ItemStack[] armorContent = equipment.getArmorContents();
            System.arraycopy(armorContent, 0, contents, 0, 4);
            contents[4] = equipment.getItemInMainHand();
            contents[5] = equipment.getItemInOffHand();
        } else {
            Arrays.fill(contents, new ItemStack(Material.AIR));
        }
        return contents;
    }

    public static ItemStack[] getContainerContents(Material type, Object container, Location location) {
        ItemStack[] contents = null;
        if (Config.getConfig((World)location.getWorld()).ITEM_TRANSACTIONS && BlockGroup.CONTAINERS.contains(type)) {
            try {
                LivingEntity entity;
                if (container == null) {
                    container = location.getBlock();
                }
                if (type == Material.ARMOR_STAND) {
                    entity = (LivingEntity)container;
                    EntityEquipment equipment = Util.getEntityEquipment(entity);
                    if (equipment != null) {
                        contents = Util.getArmorStandContents(equipment);
                    }
                } else if (type == Material.ITEM_FRAME) {
                    entity = (ItemFrame)container;
                    contents = Util.getItemFrameItem((ItemFrame)entity);
                } else if (type == Material.JUKEBOX) {
                    Jukebox blockState = (Jukebox)((Block)container).getState();
                    contents = Util.getJukeboxItem(blockState);
                } else {
                    Block block = (Block)container;
                    Inventory inventory = Util.getContainerInventory(block.getState(), true);
                    if (inventory != null) {
                        contents = inventory.getContents();
                    }
                }
                if (type == Material.ARMOR_STAND || type == Material.ITEM_FRAME) {
                    boolean hasItem = false;
                    for (ItemStack item : contents) {
                        if (item == null || item.getType().equals((Object)Material.AIR)) continue;
                        hasItem = true;
                        break;
                    }
                    if (!hasItem) {
                        contents = null;
                    }
                }
                if (contents != null) {
                    contents = Util.getContainerState(contents);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    public static Inventory getContainerInventory(BlockState blockState, boolean singleBlock) {
        Inventory inventory = null;
        try {
            if (blockState instanceof BlockInventoryHolder) {
                Material type;
                List<Material> chests;
                if (singleBlock && (chests = Arrays.asList(Material.CHEST, Material.TRAPPED_CHEST)).contains(type = blockState.getType())) {
                    inventory = ((Chest)blockState).getBlockInventory();
                }
                if (inventory == null) {
                    inventory = ((BlockInventoryHolder)blockState).getInventory();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inventory;
    }

    public static EntityEquipment getEntityEquipment(LivingEntity entity) {
        EntityEquipment equipment = null;
        try {
            equipment = entity.getEquipment();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return equipment;
    }

    public static ItemStack[] getItemFrameItem(ItemFrame entity) {
        ItemStack[] contents = null;
        try {
            contents = new ItemStack[]{entity.getItem()};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }

    public static ItemStack[] getJukeboxItem(Jukebox blockState) {
        ItemStack[] contents = null;
        try {
            contents = new ItemStack[]{blockState.getRecord()};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }

    public static int getEntityId(EntityType type) {
        if (type == null) {
            return -1;
        }
        return Util.getEntityId(type.name(), true);
    }

    public static int getEntityId(String name, boolean internal) {
        int id = -1;
        if (ConfigHandler.entities.get(name = name.toLowerCase(Locale.ROOT).trim()) != null) {
            id = ConfigHandler.entities.get(name);
        } else if (internal) {
            int entityID = ConfigHandler.entityId + 1;
            ConfigHandler.entities.put(name, entityID);
            ConfigHandler.entitiesReversed.put(entityID, name);
            ConfigHandler.entityId = entityID;
            Queue.queueEntityInsert(entityID, name);
            id = ConfigHandler.entities.get(name);
        }
        return id;
    }

    public static Material getEntityMaterial(EntityType type) {
        switch (type) {
            case ARMOR_STAND: {
                return Material.ARMOR_STAND;
            }
            case ITEM_FRAME: {
                return Material.ITEM_FRAME;
            }
            case ENDER_CRYSTAL: {
                return Material.END_CRYSTAL;
            }
            case ENDER_PEARL: {
                return Material.ENDER_PEARL;
            }
            case SPLASH_POTION: {
                return Material.SPLASH_POTION;
            }
            case THROWN_EXP_BOTTLE: {
                return Material.EXPERIENCE_BOTTLE;
            }
            case TRIDENT: {
                return Material.TRIDENT;
            }
            case FIREWORK: {
                return Material.FIREWORK_ROCKET;
            }
            case EGG: {
                return Material.EGG;
            }
            case SNOWBALL: {
                return Material.SNOWBALL;
            }
        }
        return BukkitAdapter.ADAPTER.getFrameType(type);
    }

    public static String getEntityName(int id) {
        String entityName = "";
        if (ConfigHandler.entitiesReversed.get(id) != null) {
            entityName = ConfigHandler.entitiesReversed.get(id);
        }
        return entityName;
    }

    public static EntityType getEntityType(int id) {
        EntityType entitytype = null;
        if (ConfigHandler.entitiesReversed.get(id) != null) {
            String name = ConfigHandler.entitiesReversed.get(id);
            if (name.contains(NAMESPACE)) {
                name = name.split(":")[1];
            }
            entitytype = EntityType.valueOf((String)name.toUpperCase(Locale.ROOT));
        }
        return entitytype;
    }

    public static EntityType getEntityType(String name) {
        EntityType type = null;
        if ((name = name.toLowerCase(Locale.ROOT).trim()).contains(NAMESPACE)) {
            name = name.split(":")[1];
        }
        if (ConfigHandler.entities.get(name) != null) {
            type = EntityType.valueOf((String)name.toUpperCase(Locale.ROOT));
        }
        return type;
    }

    public static int getItemStackHashCode(ItemStack item) {
        try {
            return item.hashCode();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int getMaterialId(Material material) {
        return Util.getBlockId(material.name(), true);
    }

    public static int getSpawnerType(EntityType type) {
        int result = Util.getEntityId(type);
        if (result == -1) {
            result = 0;
        }
        return result;
    }

    public static EntityType getSpawnerType(int type) {
        EntityType result = Util.getEntityType(type);
        if (result == null) {
            result = EntityType.PIG;
        }
        return result;
    }

    public static boolean isAir(Material type) {
        return type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR;
    }

    public static boolean solidBlock(Material type) {
        return type.isSolid();
    }

    public static Material getType(Block block) {
        return block.getType();
    }

    public static Material getType(int id) {
        Material material = null;
        if (ConfigHandler.materialsReversed.get(id) != null && id > 0) {
            String name = ConfigHandler.materialsReversed.get(id).toUpperCase(Locale.ROOT);
            if (name.contains(NAMESPACE.toUpperCase(Locale.ROOT))) {
                name = name.split(":")[1];
            }
            name = BukkitAdapter.ADAPTER.parseLegacyName(name);
            material = Material.getMaterial((String)name);
        }
        return material;
    }

    public static Material getType(String name) {
        Material material = null;
        if (!(name = name.toUpperCase(Locale.ROOT).trim()).startsWith("#")) {
            if (name.contains(NAMESPACE.toUpperCase(Locale.ROOT))) {
                name = name.split(":")[1];
            }
            name = BukkitAdapter.ADAPTER.parseLegacyName(name);
            material = Material.matchMaterial((String)name);
        }
        return material;
    }

    public static int getWorldId(String name) {
        int id = -1;
        try {
            if (ConfigHandler.worlds.get(name) == null) {
                int wid = ConfigHandler.worldId + 1;
                ConfigHandler.worlds.put(name, wid);
                ConfigHandler.worldsReversed.put(wid, name);
                ConfigHandler.worldId = wid;
                Queue.queueWorldInsert(wid, name);
            }
            id = ConfigHandler.worlds.get(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static String getWorldName(int id) {
        String name = "";
        try {
            if (ConfigHandler.worldsReversed.get(id) != null) {
                name = ConfigHandler.worldsReversed.get(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static boolean iceBreakCheck(BlockState block, String user, Material type) {
        if (type.equals((Object)Material.ICE)) {
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            int wid = Util.getWorldId(block.getWorld().getName());
            CacheHandler.lookupCache.put(block.getX() + "." + block.getY() + "." + block.getZ() + "." + wid, new Object[]{unixtimestamp, user, Material.WATER});
            return true;
        }
        return false;
    }

    public static boolean listContains(Set<Material> list, Material value) {
        boolean result = false;
        for (Material list_value : list) {
            if (!list_value.equals((Object)value)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void loadWorldEdit() {
        try {
            boolean validVersion = true;
            String version = Bukkit.getServer().getPluginManager().getPlugin("WorldEdit").getDescription().getVersion();
            if (version.contains(";") || version.contains("+")) {
                long value;
                if (version.contains("-beta-")) {
                    version = version.split(";")[0];
                    long value2 = Long.parseLong((version = version.split("-beta-")[1]).replaceAll("[^0-9]", ""));
                    if (value2 < 6L) {
                        validVersion = false;
                    }
                } else if ((version = version.contains("+") ? version.split("\\+")[1] : version.split(";")[1]).contains("-") && (value = Long.parseLong(version.split("-")[0].replaceAll("[^0-9]", ""))) > 0L && value < 4268L) {
                    validVersion = false;
                }
            } else if (version.contains(".")) {
                String[] worldEditVersion = version.split("-|\\.");
                if (worldEditVersion.length >= 2) {
                    worldEditVersion[0] = worldEditVersion[0].replaceAll("[^0-9]", "");
                    worldEditVersion[1] = worldEditVersion[1].replaceAll("[^0-9]", "");
                    if (worldEditVersion[0].length() == 0 || worldEditVersion[1].length() == 0 || Util.newVersion(worldEditVersion[0] + "." + worldEditVersion[1], "7.1")) {
                        validVersion = false;
                    }
                }
            } else if (version.equals("unspecified")) {
                validVersion = false;
                Plugin fawe = Bukkit.getServer().getPluginManager().getPlugin("FastAsyncWorldEdit");
                if (fawe != null) {
                    String apiVersion = Bukkit.getServer().getPluginManager().getPlugin("WorldEdit").getDescription().getAPIVersion();
                    String faweVersion = fawe.getDescription().getVersion();
                    double apiDouble = Double.parseDouble(apiVersion);
                    double faweDouble = Double.parseDouble(faweVersion);
                    if (apiDouble >= 1.13 && faweDouble >= 1.0) {
                        validVersion = true;
                    }
                }
            } else {
                validVersion = false;
            }
            if (validVersion) {
                CoreProtectEditSessionEvent.register();
            } else {
                Chat.console(Phrase.build(Phrase.INTEGRATION_VERSION, "WorldEdit"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unloadWorldEdit() {
        try {
            CoreProtectEditSessionEvent.unregister();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int matchWorld(String name) {
        int id = -1;
        try {
            String nameWid;
            if (name.startsWith("wid:") && (nameWid = name.replaceFirst("wid:", "")).length() > 0 && nameWid.equals(nameWid.replaceAll("[^0-9]", "")) && (nameWid = Util.getWorldName(Integer.parseInt(nameWid))).length() > 0) {
                name = nameWid;
            }
            String result = "";
            name = name.replaceFirst("#", "").toLowerCase(Locale.ROOT).trim();
            for (World world : Bukkit.getServer().getWorlds()) {
                String worldName = world.getName();
                if (worldName.toLowerCase(Locale.ROOT).equals(name)) {
                    result = world.getName();
                    break;
                }
                if (worldName.toLowerCase(Locale.ROOT).endsWith(name)) {
                    result = world.getName();
                    continue;
                }
                if (!worldName.toLowerCase(Locale.ROOT).replaceAll("[^a-zA-Z0-9]", "").endsWith(name)) continue;
                result = world.getName();
            }
            if (result.length() > 0) {
                id = Util.getWorldId(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static void sendConsoleComponentStartup(ConsoleCommandSender consoleSender, String string) {
        Chat.sendComponent((CommandSender)consoleSender, "\u00a7r[CoreProtect] " + string + "<COMPONENT>POPUP| | </COMPONENT>");
    }

    public static Material itemFilter(Material material, boolean blockTable) {
        if (material == null || !blockTable && material.isItem()) {
            return material;
        }
        if ((material = BukkitAdapter.ADAPTER.getPlantSeeds(material)).name().contains("WALL_")) {
            material = Material.valueOf((String)material.name().replace("WALL_", ""));
        }
        return material;
    }

    public static String nameFilter(String name, int data) {
        if (name.equals("stone")) {
            switch (data) {
                case 1: {
                    name = "granite";
                    break;
                }
                case 2: {
                    name = "polished_granite";
                    break;
                }
                case 3: {
                    name = "diorite";
                    break;
                }
                case 4: {
                    name = "polished_diorite";
                    break;
                }
                case 5: {
                    name = "andesite";
                    break;
                }
                case 6: {
                    name = "polished_andesite";
                    break;
                }
                default: {
                    name = "stone";
                }
            }
        }
        return name;
    }

    public static ItemStack newItemStack(Material type, int amount) {
        return new ItemStack(type, amount);
    }

    public static boolean isSpigot() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.ThreadedRegionizer");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getBranch() {
        Object branch = "";
        try {
            InputStreamReader reader = new InputStreamReader(((Object)((Object)CoreProtect.getInstance())).getClass().getResourceAsStream("/plugin.yml"));
            branch = YamlConfiguration.loadConfiguration((Reader)reader).getString("branch");
            reader.close();
            if (branch == null || ((String)branch).equals("${project.branch}")) {
                branch = "";
            }
            if (((String)branch).startsWith("-")) {
                branch = ((String)branch).substring(1);
            }
            if (((String)branch).length() > 0) {
                branch = "-" + (String)branch;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return branch;
    }

    public static boolean newVersion(Integer[] oldVersion, Integer[] currentVersion) {
        if (oldVersion[0] < currentVersion[0]) {
            return true;
        }
        if (oldVersion[0].equals(currentVersion[0]) && oldVersion[1] < currentVersion[1]) {
            return true;
        }
        if (oldVersion.length < 3 && currentVersion.length >= 3 && oldVersion[0].equals(currentVersion[0]) && oldVersion[1].equals(currentVersion[1]) && 0 < currentVersion[2]) {
            return true;
        }
        return oldVersion.length >= 3 && currentVersion.length >= 3 && oldVersion[0].equals(currentVersion[0]) && oldVersion[1].equals(currentVersion[1]) && oldVersion[2] < currentVersion[2];
    }

    public static boolean newVersion(Integer[] oldVersion, String currentVersion) {
        String[] currentVersionSplit = currentVersion.split("\\.");
        return Util.newVersion(oldVersion, Util.convertArray(currentVersionSplit));
    }

    public static boolean newVersion(String oldVersion, Integer[] currentVersion) {
        String[] oldVersionSplit = oldVersion.split("\\.");
        return Util.newVersion(Util.convertArray(oldVersionSplit), currentVersion);
    }

    public static boolean newVersion(String oldVersion, String currentVersion) {
        if (!oldVersion.contains(".") || !currentVersion.contains(".")) {
            return false;
        }
        String[] oldVersionSplit = oldVersion.split("\\.");
        String[] currentVersionSplit = currentVersion.split("\\.");
        return Util.newVersion(Util.convertArray(oldVersionSplit), Util.convertArray(currentVersionSplit));
    }

    public static Map<Integer, Object> serializeItemStackLegacy(ItemStack itemStack, String faceData, int slot) {
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        Map<String, Object> itemMap = Util.serializeItemStack(itemStack, faceData, slot);
        if (itemMap.size() > 1) {
            result.put(0, itemMap.get("0"));
            result.put(1, itemMap.get("1"));
        }
        return result;
    }

    public static ItemStack unserializeItemStackLegacy(Object value) {
        ItemStack result = null;
        if (value instanceof Map) {
            HashMap newMap = new HashMap();
            Map itemMap = (Map)value;
            newMap.put("0", itemMap.get(0));
            newMap.put("1", itemMap.get(1));
            result = Util.unserializeItemStack(newMap);
        }
        return result;
    }

    public static Map<String, Object> serializeItemStack(ItemStack itemStack, String faceData, int slot) {
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) {
            ItemStack item = itemStack.clone();
            List<List<Map<String, Object>>> metadata = ItemMetaHandler.seralize(item, null, faceData, slot);
            item.setItemMeta(null);
            itemMap.put("0", item.serialize());
            itemMap.put("1", metadata);
        }
        return itemMap;
    }

    public static ItemStack unserializeItemStack(Object value) {
        ItemStack result = null;
        if (value instanceof Map) {
            Map itemMap = (Map)value;
            ItemStack item = ItemStack.deserialize((Map)((Map)itemMap.get("0")));
            List metadata = (List)itemMap.get("1");
            Object[] populatedStack = Rollback.populateItemStack(item, metadata);
            result = (ItemStack)populatedStack[2];
        }
        return result;
    }

    public static List<Object> processMeta(BlockState block) {
        ArrayList<Object> meta = new ArrayList<Object>();
        try {
            if (block instanceof CommandBlock) {
                CommandBlock commandBlock = (CommandBlock)block;
                String command = commandBlock.getCommand();
                if (command.length() > 0) {
                    meta.add(command);
                }
            } else if (block instanceof Banner) {
                Banner banner = (Banner)block;
                meta.add(banner.getBaseColor());
                List patterns = banner.getPatterns();
                for (Pattern pattern : patterns) {
                    meta.add(pattern.serialize());
                }
            } else if (block instanceof ShulkerBox) {
                ShulkerBox shulkerBox = (ShulkerBox)block;
                ItemStack[] inventory = shulkerBox.getSnapshotInventory().getStorageContents();
                int slot = 0;
                for (ItemStack itemStack : inventory) {
                    Map<Integer, Object> itemMap = Util.serializeItemStackLegacy(itemStack, null, slot);
                    if (itemMap.size() > 0) {
                        meta.add(itemMap);
                    }
                    ++slot;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (meta.isEmpty()) {
            meta = null;
        }
        return meta;
    }

    public static void sendBlockChange(Player player, Location location, BlockData blockData) {
        player.sendBlockChange(location, blockData);
    }

    public static BlockData createBlockData(Material material) {
        try {
            BlockData result = material.createBlockData();
            if (result instanceof Waterlogged) {
                ((Waterlogged)result).setWaterlogged(false);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void prepareTypeAndData(Map<Block, BlockData> map, Block block, Material type, BlockData blockData, boolean update) {
        if (blockData == null) {
            blockData = Util.createBlockData(type);
        }
        if (!update) {
            Util.setTypeAndData(block, type, blockData, update);
            map.remove(block);
        } else {
            map.put(block, blockData);
        }
    }

    public static void setTypeAndData(Block block, Material type, BlockData blockData, boolean update) {
        if (blockData == null && type != null) {
            blockData = Util.createBlockData(type);
        }
        if (blockData != null) {
            block.setBlockData(blockData, update);
        }
    }

    public static boolean successfulQuery(Connection connection, String query) {
        boolean result = false;
        try {
            PreparedStatement preparedStmt = connection.prepareStatement(query);
            ResultSet resultSet = preparedStmt.executeQuery();
            if (resultSet.isBeforeFirst()) {
                result = true;
            }
            resultSet.close();
            preparedStmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String[] toStringArray(String[] array) {
        int size = array.length;
        if (size == 11) {
            String time = array[0];
            String user = array[1];
            String x = array[2];
            String y = array[3];
            String z = array[4];
            String type = array[5];
            String data = array[6];
            String action = array[7];
            String rolledBack = array[8];
            String wid = array[9];
            String blockData = array[10];
            return new String[]{time, user, x, y, z, type, data, action, rolledBack, wid, "", "", blockData};
        }
        return null;
    }

    public static void updateBlock(BlockState block) {
        Scheduler.runTask(CoreProtect.getInstance(), () -> {
            try {
                Block currentBlock;
                if (block.getBlockData() instanceof Waterlogged && (currentBlock = block.getBlock()).getType().equals((Object)block.getType())) {
                    block.setBlockData(currentBlock.getBlockData());
                }
                block.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, block.getLocation());
    }

    public static void updateInventory(Player player) {
        player.updateInventory();
    }

    public static boolean checkWorldEdit() {
        boolean result = false;
        for (World world : Bukkit.getServer().getWorlds()) {
            if (!Config.getConfig((World)world).WORLDEDIT) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getWidIndex(String queryTable) {
        String index = "";
        boolean isMySQL = Config.getGlobal().MYSQL;
        if (isMySQL) {
            index = "USE INDEX(wid) ";
        } else {
            switch (queryTable) {
                case "block": {
                    index = "INDEXED BY block_index ";
                    break;
                }
                case "container": {
                    index = "INDEXED BY container_index ";
                    break;
                }
                case "item": {
                    index = "INDEXED BY item_index ";
                    break;
                }
                case "sign": {
                    index = "INDEXED BY sign_index ";
                    break;
                }
                case "chat": {
                    index = "INDEXED BY chat_wid_index ";
                    break;
                }
                case "command": {
                    index = "INDEXED BY command_wid_index ";
                    break;
                }
                case "session": {
                    index = "INDEXED BY session_index ";
                    break;
                }
            }
        }
        return index;
    }

    public static int rolledBack(int rolledBack, boolean isInventory) {
        switch (rolledBack) {
            case 1: {
                return isInventory ? 0 : 1;
            }
            case 2: {
                return isInventory ? 1 : 0;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static int toggleRolledBack(int rolledBack, boolean isInventory) {
        switch (rolledBack) {
            case 1: {
                return isInventory ? 3 : 0;
            }
            case 2: {
                return isInventory ? 0 : 3;
            }
            case 3: {
                return isInventory ? 1 : 2;
            }
        }
        return isInventory ? 2 : 1;
    }

    public static int getSignData(boolean frontGlowing, boolean backGlowing) {
        if (frontGlowing && backGlowing) {
            return 3;
        }
        if (backGlowing) {
            return 2;
        }
        if (frontGlowing) {
            return 1;
        }
        return 0;
    }

    public static boolean isSideGlowing(boolean isFront, int data) {
        return isFront && (data == 1 || data == 3) || !isFront && (data == 2 || data == 3);
    }
}

