/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.enter.GuildLogoShop;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.NumberUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.service.GuildLogoShopService;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AddLogoCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addLogo";
    }

    @Override
    public String permission() {
        return "playerGuild.addLogo";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        int rst;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Integer price = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
        Integer level = 1;
        if (args.length > 2) {
            level = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        }
        itemInMainHand.setAmount(1);
        Integer finalLevel = level;
        if (args.length > 3) {
            Integer id = NumberUtil.isNumericToInt(args[3]);
            Optional<GuildLogoShop> guildLogoShopOptional = GuildLogoShopService.getInstance().findById(id);
            AssertUtil.notTrue(!guildLogoShopOptional.isPresent(), sender, BaseUtil.getMsgNotColor("failureMsg"));
            GuildLogoShop guildLogoShop = guildLogoShopOptional.get();
            String logoName = ItemStackUtil.itemStackSerialize(itemInMainHand);
            guildLogoShop.setItemStack(logoName);
            guildLogoShop.setPrice(price);
            guildLogoShop.setLevel(finalLevel);
            rst = GuildLogoShopService.getInstance().update(guildLogoShop);
            GuildLogoService.getInstance().updateLogoNameByLogoId(guildLogoShop.getId(), logoName);
            GuildInfoService.getInstance().updateLogoByLogoId(guildLogoShop.getId(), logoName);
        } else {
            GuildLogoShop guildLogoShop = new GuildLogoShop();
            guildLogoShop.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
            guildLogoShop.setPrice(price);
            guildLogoShop.setLevel(finalLevel);
            guildLogoShop.setDefaultLogoFlag(0);
            rst = GuildLogoShopService.getInstance().add(guildLogoShop);
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst > 0 ? "succeedMsg" : "failureMsg"));
    }
}

