/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.enter.GuildLogoShop;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.NumberUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildLogoShopService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SetDefaultLogoCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "setDefaultLogo";
    }

    @Override
    public String permission() {
        return "playerGuild.setDefaultLogo";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
        itemInMainHand.setAmount(1);
        GuildLogoShop guildLogoShop = new GuildLogoShop();
        guildLogoShop.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
        guildLogoShop.setPrice(0);
        int level = 1;
        if (args.length > 2) {
            level = NumberUtil.isNumericToInt(args[1]);
        }
        guildLogoShop.setLevel(level);
        guildLogoShop.setDefaultLogoFlag(1);
        int logoId = GuildLogoShopService.getInstance().add(guildLogoShop);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(logoId > 0 ? "succeedMsg" : "failureMsg"));
    }
}

