/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildLogo;
import com.handy.guild.enter.GuildLogoShop;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.hook.WorldUtil;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.service.GuildLogoShopService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UpCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "up";
    }

    @Override
    public String permission() {
        return "playerGuild.up";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] strings) {
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        UpCommand.up(player);
    }

    public static void up(Player player) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        int upMoney = ConfigUtil.CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".upMoney");
        int upProsperityDegree = ConfigUtil.CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".upProsperityDegree");
        int upMember = ConfigUtil.CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".upMember", 0);
        if (guildInfo.getProsperityDegree() < upProsperityDegree) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("upProsperityDegree"));
            return;
        }
        if (guildInfo.getMoney() < upMoney) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("upMoney"));
            return;
        }
        if (guildInfo.getMemberCount() < upMember) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("upMember"));
            return;
        }
        if (upMoney == 0 && upProsperityDegree == 0 && upMember == 0) {
            MessageUtil.sendMessage(player, ConfigUtil.SETTING_CONFIG.getString("up.maxLevel"));
            return;
        }
        int memberMaxCount = ConfigUtil.CONFIG.getInt("guildSetting." + (guildInfo.getLevel() + 1) + ".totalNumber");
        if (memberMaxCount == 0) {
            return;
        }
        GuildInfoService.getInstance().subtractMoneyById(guildInfo.getId(), upMoney);
        GuildInfoService.getInstance().upLevel(guildInfo.getId(), 1, memberMaxCount);
        Optional<GuildInfo> infoOptional = GuildInfoService.getInstance().findById(guildInfo.getId());
        if (!infoOptional.isPresent()) {
            return;
        }
        GuildInfo info = infoOptional.get();
        WorldUtil.setGuildBorder(info);
        HandySchedulerUtil.runTask(() -> WorldUtil.setGameRule(info.getWorldName()));
        PlayerTitleUtil.setGuildTitle(info.getId());
        Optional<GuildLogoShop> guildLogoShopOptional = GuildLogoShopService.getInstance().findDefaultLogo(guildInfo.getLevel() + 1);
        if (guildLogoShopOptional.isPresent()) {
            GuildLogoShop guildLogoShop = guildLogoShopOptional.get();
            GuildLogoService.getInstance().updateUseToFalse(guildInfo.getId());
            GuildLogo guildLogo = new GuildLogo();
            guildLogo.setGuildInfoId(guildInfo.getId());
            guildLogo.setLogoId(guildLogoShop.getId());
            guildLogo.setLogoName(guildLogoShop.getItemStack());
            guildLogo.setUseFlag(true);
            GuildLogoService.getInstance().add(guildLogo);
            GuildInfoService.getInstance().updateLogoById(guildInfo.getId(), guildLogoShop.getId(), guildLogoShop.getItemStack());
        }
    }
}

