/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.player;

import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.JsonUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.param.GuildSpawn;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetSpawnCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "setSpawn";
    }

    @Override
    public String permission() {
        return "playerGuild.setSpawn";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] strings) {
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        Location location = player.getLocation();
        String worldName = Objects.requireNonNull(location.getWorld()).getName();
        List noWorldList = ConfigUtil.SETTING_CONFIG.getStringList("setSpawn.noWorld");
        if (CollUtil.isNotEmpty(noWorldList) && noWorldList.contains(worldName)) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noSetSpawn"));
            return;
        }
        String serverName = ConfigUtil.CONFIG.getString("serverName", "server");
        GuildSpawn guildSpawn = new GuildSpawn();
        guildSpawn.setServerName(serverName);
        guildSpawn.setX(location.getX());
        guildSpawn.setY(location.getY());
        guildSpawn.setZ(location.getZ());
        guildSpawn.setYaw(location.getYaw());
        guildSpawn.setPitch(location.getPitch());
        guildSpawn.setWorld(worldName);
        String guildSpawnLocation = JsonUtil.toJson(guildSpawn);
        int rst = GuildInfoService.getInstance().updateSpawnLocation(guildPlayer.getGuildInfoId(), guildSpawnLocation, null);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst > 0 ? "succeedMsg" : "failureMsg"));
    }
}

