/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildInvitationGui {
    private static final GuildInvitationGui INSTANCE = new GuildInvitationGui();

    private GuildInvitationGui() {
    }

    public static GuildInvitationGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.INVITATION_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.INVITATION_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_INVITATION.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_INVITATION.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
        GuildUtil.setHead(handyInventory.getInventory());
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Map<Integer, Object> map = handyInventory.getObjMap();
        List<String> playerNames = this.getPlayerNameList(handyInventory);
        if (CollUtil.isEmpty(playerNames)) {
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(handyInventory.getId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        String name = ConfigUtil.INVITATION_CONFIG.getString("member.name", "${player_name}");
        String materialStr = ConfigUtil.INVITATION_CONFIG.getString("member.material");
        List<String> loreList = ConfigUtil.INVITATION_CONFIG.getStringList("member.lore");
        boolean isEnchant = ConfigUtil.INVITATION_CONFIG.getBoolean("member.isEnchant", false);
        int customModelDataId = ConfigUtil.INVITATION_CONFIG.getInt("member.custom-model-data");
        boolean hideFlag = ConfigUtil.INVITATION_CONFIG.getBoolean("member.hideFlag", true);
        LinkedHashMap<String, ItemStack> itemStackMap = new LinkedHashMap<String, ItemStack>();
        for (String playerName : playerNames) {
            String newName = name.replace("${player_name}", playerName);
            loreList = PlaceholderApiUtil.set(BaseUtil.getOfflinePlayer(playerName), loreList);
            ItemStack itemStack = ItemStackUtil.getItemStack(materialStr, newName, loreList, isEnchant, customModelDataId, hideFlag, this.replaceMap(playerName, guildInfo));
            itemStackMap.put(playerName, itemStack);
        }
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (String playerName : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(playerName));
            map.put(index, playerName);
        }
    }

    private List<String> getPlayerNameList(HandyInventory handyInventory) {
        Integer pageNum = handyInventory.getPageNum();
        Integer pageSize = handyInventory.getPageSize();
        ArrayList<String> playerNameList = new ArrayList<String>();
        Collection onlinePlayers = Bukkit.getOnlinePlayers();
        handyInventory.setPageCount(onlinePlayers.size());
        if (CollUtil.isEmpty(onlinePlayers)) {
            return playerNameList;
        }
        List<String> playerNames = onlinePlayers.stream().map(Player::getName).collect(Collectors.toList());
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByPlayerNameList(playerNames);
        Map<String, GuildPlayer> guildPlayerMap = guildPlayerList.stream().collect(Collectors.groupingBy(GuildPlayer::getPlayerName, Collectors.collectingAndThen(Collectors.toList(), value -> (GuildPlayer)value.get(0))));
        for (String playerName : playerNames) {
            if (guildPlayerMap.get(playerName) != null) continue;
            playerNameList.add(playerName);
        }
        if (pageNum == null) {
            return playerNameList;
        }
        return playerNameList.stream().skip((long)(pageNum - 1) * (long)pageSize.intValue()).limit(pageSize.intValue()).collect(Collectors.toList());
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.INVITATION_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.INVITATION_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.INVITATION_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.INVITATION_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceMap(String playerName, GuildInfo guildInfo) {
        List<Integer> guildIdList;
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(3);
        Integer money = guildInfo.getMoney();
        int price = ConfigUtil.INVITATION_CONFIG.getInt("member.price");
        String button = ConfigUtil.INVITATION_CONFIG.getString("member.noButton");
        if (money >= price) {
            button = ConfigUtil.INVITATION_CONFIG.getString("member.yesButton");
        }
        if (CollUtil.isNotEmpty(guildIdList = GuildConstants.INVITATION_PLAYER_MAP.get(playerName)) && guildIdList.contains(guildInfo.getId())) {
            button = ConfigUtil.INVITATION_CONFIG.getString("member.haveButton");
        }
        replaceMap.put("price", price + "");
        replaceMap.put("money", money.toString());
        replaceMap.put("button", button);
        return replaceMap;
    }
}

