/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildMemberGui {
    private static final GuildMemberGui INSTANCE = new GuildMemberGui();

    private GuildMemberGui() {
    }

    public static GuildMemberGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.MEMBER_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.MEMBER_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_MEMBER.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_MEMBER.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
        GuildUtil.setHead(handyInventory.getInventory());
    }

    private void setDate(HandyInventory handyInventory) {
        int i;
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Map<Integer, Object> objMap = handyInventory.getObjMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildPlayer> page = GuildPlayerService.getInstance().page(handyInventory.getId(), handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildPlayer> records = page.getRecords();
        String name = ConfigUtil.MEMBER_CONFIG.getString("member.name", "");
        String materialStr = ConfigUtil.MEMBER_CONFIG.getString("member.material");
        List loreList = ConfigUtil.MEMBER_CONFIG.getStringList("member.lore");
        boolean isEnchant = ConfigUtil.MEMBER_CONFIG.getBoolean("member.isEnchant", false);
        int customModelDataId = ConfigUtil.MEMBER_CONFIG.getInt("member.custom-model-data");
        boolean hideFlag = ConfigUtil.MEMBER_CONFIG.getBoolean("member.hideFlag", true);
        LinkedHashMap<Integer, ItemStack> itemStackMap = new LinkedHashMap<Integer, ItemStack>();
        LinkedHashMap<Integer, String> playerNameMap = new LinkedHashMap<Integer, String>();
        for (i = 0; i < records.size(); ++i) {
            GuildPlayer guildPlayer = records.get(i);
            String roleName = GuildRoleEnum.getRoleName(guildPlayer.getRoleId());
            String newName = name.replace("${player_name}", BaseUtil.replaceChatColor(guildPlayer.getPlayerName())).replace("${player_role}", roleName);
            String ranking = String.valueOf(i + 1 + (handyInventory.getPageNum() - 1) * GuildConstants.GUI_INDEX.size());
            ItemStack itemStack = ItemStackUtil.getItemStack(materialStr, newName, loreList, isEnchant, customModelDataId, hideFlag, this.replaceMap(guildPlayer, ranking));
            itemStackMap.put(guildPlayer.getId(), itemStack);
            playerNameMap.put(guildPlayer.getId(), guildPlayer.getPlayerName());
        }
        i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (Integer guildPlayerId : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(guildPlayerId));
            map.put(index, guildPlayerId);
            objMap.put(index, playerNameMap.get(guildPlayerId));
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        int impeachmentDay;
        long offlineDay;
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.MEMBER_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.MEMBER_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.MEMBER_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.MEMBER_CONFIG, inventory, "pane");
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findOneRoleByGuildId(handyInventory.getId());
        if (guildPlayerOptional.isPresent() && (offlineDay = GuildMemberGui.getOfflineDay(guildPlayerOptional.get())) > (long)(impeachmentDay = ConfigUtil.MEMBER_CONFIG.getInt("impeachment.day", 14))) {
            HandyInventoryUtil.setButton(ConfigUtil.MEMBER_CONFIG, inventory, "impeachment");
        }
    }

    private Map<String, String> replaceMap(GuildPlayer guildPlayer, String ranking) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(11);
        replaceMap.put("player_name", BaseUtil.replaceChatColor(guildPlayer.getPlayerName()));
        replaceMap.put("player_ranking", ranking);
        replaceMap.put("player_role", GuildRoleEnum.getRoleName(guildPlayer.getRoleId()));
        replaceMap.put("player_money", guildPlayer.getMoney().toString());
        replaceMap.put("player_total_money", guildPlayer.getTotalMoney().toString());
        replaceMap.put("player_week_money", guildPlayer.getWeekMoney().toString());
        replaceMap.put("player_guild_money", guildPlayer.getGuildMoney().toString());
        replaceMap.put("total_ore", guildPlayer.getTotalOre() != null ? guildPlayer.getTotalOre().toString() : "0");
        replaceMap.put("player_join_time", DateUtil.format(guildPlayer.getJoinTime(), "yyyy-MM-dd HH:mm:ss"));
        replaceMap.put("last_join_time", guildPlayer.getLastJoinTime() != null ? DateUtil.format(guildPlayer.getLastJoinTime(), "yyyy-MM-dd HH:mm:ss") : "");
        replaceMap.put("last_quit_time", guildPlayer.getLastQuitTime() != null ? DateUtil.format(guildPlayer.getLastQuitTime(), "yyyy-MM-dd HH:mm:ss") : "");
        String online = ConfigUtil.MEMBER_CONFIG.getString("member.online", "");
        String offline = ConfigUtil.MEMBER_CONFIG.getString("member.offline", "");
        if (guildPlayer.getLastJoinTime() != null && guildPlayer.getLastQuitTime() != null && guildPlayer.getLastJoinTime().getTime() > guildPlayer.getLastQuitTime().getTime()) {
            replaceMap.put("player_status", online);
        }
        if (guildPlayer.getLastQuitTime() == null) {
            replaceMap.put("player_status", online);
        }
        if (guildPlayer.getLastJoinTime() != null && guildPlayer.getLastQuitTime() != null && guildPlayer.getLastJoinTime().getTime() <= guildPlayer.getLastQuitTime().getTime()) {
            long between = DateUtil.between(guildPlayer.getLastQuitTime(), new Date(), ChronoUnit.DAYS);
            replaceMap.put("player_status", offline.replace("${day}", between + ""));
        }
        return replaceMap;
    }

    public static long getOfflineDay(GuildPlayer guildPlayer) {
        if (guildPlayer.getLastJoinTime() != null && guildPlayer.getLastQuitTime() != null && guildPlayer.getLastJoinTime().getTime() > guildPlayer.getLastQuitTime().getTime()) {
            return 0L;
        }
        if (guildPlayer.getLastQuitTime() == null) {
            return 0L;
        }
        if (guildPlayer.getLastJoinTime() != null) {
            return DateUtil.between(guildPlayer.getLastQuitTime(), new Date(), ChronoUnit.DAYS);
        }
        return 0L;
    }
}

