/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildPvpLocationService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildSelectLocationGui {
    private static final GuildSelectLocationGui INSTANCE = new GuildSelectLocationGui();

    private GuildSelectLocationGui() {
    }

    public static GuildSelectLocationGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.PVP_LOCATION_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.PVP_LOCATION_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_SELECT_LOCATION.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_SELECT_LOCATION.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> intMap = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildPvpLocation> page = GuildPvpLocationService.getInstance().page(GuildActivityType.MATCH.getType(), handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildPvpLocation> records = page.getRecords();
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        ArrayList<Integer> haveIdList = new ArrayList<Integer>();
        for (Integer guildId : MatchConstants.GUILD_PVP_START_LOCATION_MAP.keySet()) {
            haveIdList.add(MatchConstants.GUILD_PVP_START_LOCATION_MAP.get(guildId));
        }
        String selLocation = ConfigUtil.PVP_LOCATION_CONFIG.getString("selLocation");
        String noSelLocation = ConfigUtil.PVP_LOCATION_CONFIG.getString("noSelLocation");
        for (GuildPvpLocation guildPvpLocation : records) {
            Integer index = guiIndexList.get(i++);
            ArrayList<String> loreList = new ArrayList<String>();
            if (haveIdList.contains(guildPvpLocation.getId())) {
                loreList.add(noSelLocation);
            } else {
                loreList.add(selLocation);
            }
            ItemStack itemStack = ItemStackUtil.getItemStack("DIAMOND_BOOTS", guildPvpLocation.getName(), loreList);
            inventory.setItem(index.intValue(), itemStack);
            if (haveIdList.contains(guildPvpLocation.getId())) continue;
            intMap.put(index, guildPvpLocation.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.PVP_LOCATION_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.PVP_LOCATION_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.PVP_LOCATION_CONFIG, inventory, "random");
        HandyInventoryUtil.setButton(ConfigUtil.PVP_LOCATION_CONFIG, inventory, "pane");
    }
}

