/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuildViewGui {
    private static final GuildViewGui INSTANCE = new GuildViewGui();

    private GuildViewGui() {
    }

    public static GuildViewGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.VIEW_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.VIEW_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_VIEW.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_VIEW.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(handyInventory.getId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        boolean menuEnable = ConfigUtil.VIEW_CONFIG.getBoolean("menu.enable");
        if (menuEnable) {
            List<String> loreList = ConfigUtil.VIEW_CONFIG.getStringList("menu.lore");
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(guildInfo.getLogoName());
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(guildInfo.getGuildName()));
            if (CollUtil.isEmpty(loreList)) {
                loreList = StrUtil.strToStrList(guildInfo.getDescription());
            }
            loreList = PlaceholderApiUtil.set(player, loreList);
            itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
            ItemStackUtil.hideAttributes(itemMeta);
            ItemStackUtil.hideEnchant(itemMeta);
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(ConfigUtil.VIEW_CONFIG.getInt("menu.index"), itemStack);
        }
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "notice");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "member");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "spawn");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "task");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "shop", this.replaceMap(guildPlayer));
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "bank");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "signin");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "buff");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "sacredStone");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "activity");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "donate");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "exit");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "pane");
        if (guildPlayer.getRoleId() < GuildRoleEnum.THREE.getRoleId()) {
            HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "admin");
        }
        HandyInventoryUtil.setCustomButton(ConfigUtil.VIEW_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> replaceMap(GuildPlayer guildPlayer) {
        int buyRoleLimit = ConfigUtil.VIEW_CONFIG.getInt("shop.buyRoleLimit", 4);
        String button = ConfigUtil.VIEW_CONFIG.getString("shop.yesButton");
        if (guildPlayer.getRoleId() > buyRoleLimit) {
            button = ConfigUtil.VIEW_CONFIG.getString("shop.noRoleButton");
        }
        return MapUtil.of("button", button);
    }
}

