/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildNotice;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildNoticeService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ViewNoticeGui {
    private static final ViewNoticeGui INSTANCE = new ViewNoticeGui();

    private ViewNoticeGui() {
    }

    public static ViewNoticeGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.NOTICE_CONFIG.getString("adminTitle");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.NOTICE_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_NOTICE.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_NOTICE.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildNotice> page = GuildNoticeService.getInstance().page(handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildNotice> records = page.getRecords();
        String name = ConfigUtil.NOTICE_CONFIG.getString("adminNotice.name", "");
        String materialStr = ConfigUtil.NOTICE_CONFIG.getString("adminNotice.material");
        List loreList = ConfigUtil.NOTICE_CONFIG.getStringList("adminNotice.lore");
        int customModelDataId = ConfigUtil.NOTICE_CONFIG.getInt("adminNotice.custom-model-data");
        boolean hideFlag = ConfigUtil.NOTICE_CONFIG.getBoolean("notice.hideFlag", true);
        LinkedHashMap<Integer, ItemStack> itemStackMap = new LinkedHashMap<Integer, ItemStack>();
        for (GuildNotice guildNotice : records) {
            String newName = name.replace("${title}", BaseUtil.replaceChatColor(guildNotice.getTitle()));
            List<String> newLoreList = ItemStackUtil.loreBatchReplaceMap(loreList, GuildUtil.getDescriptionMap(guildNotice.getContent()), null);
            ItemStack itemStack = ItemStackUtil.getItemStack(materialStr, newName, newLoreList, false, customModelDataId, hideFlag, this.replaceMap(guildNotice));
            itemStackMap.put(guildNotice.getId(), itemStack);
        }
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (Integer noticeId : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(noticeId));
            map.put(index, noticeId);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceMap(GuildNotice guildNotice) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(guildNotice.getSendPlayerName());
        if (!guildPlayerOptional.isPresent()) {
            return MapUtil.of();
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(4);
        replaceMap.put("player_name", BaseUtil.replaceChatColor(guildNotice.getSendPlayerName()));
        replaceMap.put("guild_name", guildPlayer.getGuildInfoName());
        replaceMap.put("player_role", GuildRoleEnum.getRoleName(guildPlayer.getRoleId()));
        replaceMap.put("create_time", DateUtil.format(guildNotice.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
        return replaceMap;
    }
}

