/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildLogo;
import com.handy.guild.enter.GuildLogoShop;
import com.handy.guild.inventory.GuildLogoShopGui;
import com.handy.guild.inventory.GuildSettingGui;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.service.GuildLogoShopService;
import com.handy.guild.util.ConfigUtil;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildLogoShopClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_LOGO_SHOP.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Integer guildId = handyInventory.getId();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LOGO_SHOP_CONFIG, "back")) {
            Inventory inventory = GuildSettingGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LOGO_SHOP_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                GuildLogoShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LOGO_SHOP_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                GuildLogoShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        Integer id = map.get(rawSlot);
        if (id == null) {
            return;
        }
        Optional<GuildLogoShop> guildLogoShopOptional = GuildLogoShopService.getInstance().findById(id);
        if (!guildLogoShopOptional.isPresent()) {
            return;
        }
        GuildLogoShop guildLogoShop = guildLogoShopOptional.get();
        Integer price = guildLogoShop.getPrice();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (guildLogoShop.getLevel() > guildInfo.getLevel()) {
            String levelButton = ConfigUtil.LOGO_SHOP_CONFIG.getString("levelButton", "${level}").replace("${level}", guildLogoShop.getLevel().toString());
            MessageUtil.sendMessage(player, levelButton);
            return;
        }
        if (guildInfo.getMoney() < price) {
            MessageUtil.sendMessage(player, ConfigUtil.LOGO_SHOP_CONFIG.getString("noButton"));
            return;
        }
        GuildInfoService.getInstance().subtractMoneyById(guildId, price);
        GuildLogo guildLogo = new GuildLogo();
        guildLogo.setGuildInfoId(guildId);
        guildLogo.setLogoId(guildLogoShop.getId());
        guildLogo.setLogoName(guildLogoShop.getItemStack());
        guildLogo.setUseFlag(false);
        GuildLogoService.getInstance().add(guildLogo);
        MessageUtil.sendMessage(player, ConfigUtil.LOGO_SHOP_CONFIG.getString("buyMsg"));
        GuildLogoShopGui.getInstance().setInventoryDate(handyInventory);
    }
}

