/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.inventory.GuildManageMemberGui;
import com.handy.guild.inventory.GuildMemberGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.listener.gui.ConfirmClickEvent;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.NoticeUtil;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildMemberClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_MEMBER.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MEMBER_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MEMBER_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                GuildMemberGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MEMBER_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                GuildMemberGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MEMBER_CONFIG, "impeachment")) {
            GuildMemberClickEvent.impeachment(handyInventory);
            return;
        }
        Integer id = map.get(rawSlot);
        if (id == null) {
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findById(id);
        if (!guildPlayerOptional.isPresent()) {
            GuildMemberGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildPlayer> clickGuildPlayerOpt = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!clickGuildPlayerOpt.isPresent()) {
            return;
        }
        GuildPlayer clickGuildPlayer = clickGuildPlayerOpt.get();
        if (clickGuildPlayer.getRoleId() >= guildPlayer.getRoleId() || clickGuildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            return;
        }
        Inventory inventory = GuildManageMemberGui.getInstance().createGui(player, handyInventory.getId(), id);
        handyInventory.syncOpen(inventory);
    }

    private static void impeachment(HandyInventory handyInventory) {
        int impeachmentDay;
        Player player = handyInventory.getPlayer();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findOneRoleByGuildId(handyInventory.getId());
        if (!guildPlayerOptional.isPresent()) {
            GuildMemberGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        GuildPlayer oneGuildPlayer = guildPlayerOptional.get();
        long offlineDay = GuildMemberGui.getOfflineDay(oneGuildPlayer);
        if (offlineDay <= (long)(impeachmentDay = ConfigUtil.MEMBER_CONFIG.getInt("impeachment.day", 14))) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("impeachmentOneFailMsg"));
            GuildMemberGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        Optional<GuildPlayer> oneTotalMoneyGuildPlayerOptional = GuildPlayerService.getInstance().findOneTotalMoneyByGuildId(handyInventory.getId());
        if (!oneTotalMoneyGuildPlayerOptional.isPresent()) {
            GuildMemberGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        GuildPlayer oneTotalMoneyGuildPlayer = oneTotalMoneyGuildPlayerOptional.get();
        if (oneGuildPlayer.getId().equals(oneTotalMoneyGuildPlayer.getId())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("impeachmentFailMsg"));
            return;
        }
        ConfirmClickEvent.upRole(oneTotalMoneyGuildPlayer.getId(), oneGuildPlayer.getId());
        GuildMemberGui.getInstance().setInventoryDate(handyInventory);
        String impeachmentSucceedMsg = BaseUtil.getMsgNotColor("impeachmentSucceedMsg");
        MessageUtil.sendMessage(player, StrUtil.replace(impeachmentSucceedMsg, "playerName", oneTotalMoneyGuildPlayer.getPlayerName()));
        String impeachmentSucceedNotice = BaseUtil.getMsgNotColor("impeachmentSucceedNotice");
        if (StrUtil.isNotEmpty(impeachmentSucceedNotice)) {
            impeachmentSucceedNotice = StrUtil.replace(impeachmentSucceedNotice, "one", oneGuildPlayer.getPlayerName());
            impeachmentSucceedNotice = StrUtil.replace(impeachmentSucceedNotice, "player", player.getName());
            impeachmentSucceedNotice = StrUtil.replace(impeachmentSucceedNotice, "successor", oneTotalMoneyGuildPlayer.getPlayerName());
            NoticeUtil.sendNotice(player, impeachmentSucceedNotice, false);
        }
    }
}

