/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.command.player.JoinCommand;
import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildSortEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.inventory.GuildOpenGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildOpenClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_OPEN.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                GuildOpenGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                GuildOpenGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "search")) {
            GuildSortEnum nextEnum = GuildSortEnum.getNextEnum(handyInventory.getSearchType());
            handyInventory.setSearchType(nextEnum.getName());
            GuildOpenGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.OPEN_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            HandySchedulerUtil.runTask(() -> player.chat("/" + command.trim()));
            return;
        }
        Integer guildIndoId = map.get(rawSlot);
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "me") && guildIndoId != null) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, map.get(rawSlot));
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "create") && guildIndoId == null) {
            GuildConstants.CREATE_GUILD_INFO_MAP.put(player.getUniqueId(), "add");
            MessageUtil.sendMessage(player, ConfigUtil.OPEN_CONFIG.getString("create.nameMsg"));
            handyInventory.syncClose();
            return;
        }
        if (GuildConstants.GUI_INDEX.contains(rawSlot)) {
            Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!guildPlayerOptional.isPresent()) {
                JoinCommand.join(player, guildIndoId);
                GuildOpenGui.getInstance().setInventoryDate(handyInventory);
                return;
            }
            GuildPlayer guildPlayer = guildPlayerOptional.get();
            if (map.get(rawSlot).equals(guildPlayer.getGuildInfoId())) {
                Inventory inventory = GuildViewGui.getInstance().createGui(player, map.get(rawSlot));
                handyInventory.syncOpen(inventory);
            }
        }
    }
}

