/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.season;

import com.handy.guild.PlayerGuild;
import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPvp;
import com.handy.guild.enter.GuildPvpLog;
import com.handy.guild.enter.GuildPvpPlayerLog;
import com.handy.guild.event.GuildSeasonPvpEndEvent;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.listener.match.GuildPvpEndEventListener;
import com.handy.guild.param.GuildSeasonPvpPlayerParam;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPvpLogService;
import com.handy.guild.service.GuildPvpPlayerLogService;
import com.handy.guild.service.GuildPvpService;
import com.handy.guild.util.BuffManageUtil;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.KitPvpUtil;
import com.handy.guild.util.LeatherUtil;
import com.handy.playerrace.api.PlayerRaceApi;
import com.handy.playertitle.api.PlayerTitleApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@HandyListener
public class GuildSeasonPvpEndEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onGuildSeasonPvpEndLog(GuildSeasonPvpEndEvent event) {
        Integer guildId = event.getGuildId();
        Integer rank = event.getRank();
        List<GuildSeasonPvpPlayerParam> playerParams = event.getPlayerParams();
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            Optional<GuildInfo> guildInfoOptional;
            Date endTime = new Date();
            Date startTime = SeasonConstants.START_TIME;
            if (startTime == null) {
                startTime = new Date();
            }
            if (!(guildInfoOptional = GuildInfoService.getInstance().findById(guildId)).isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            GuildPvpLog failGuildPvpLog = new GuildPvpLog();
            failGuildPvpLog.setType(GuildActivityType.SEASON.getType());
            failGuildPvpLog.setGuildInfoId(guildId);
            failGuildPvpLog.setGuildInfoName(guildInfo.getGuildName());
            failGuildPvpLog.setStartTime(startTime);
            failGuildPvpLog.setSeason(event.getSeason());
            failGuildPvpLog.setRank(rank);
            failGuildPvpLog.setEndTime(endTime);
            int guildPvpLogId = GuildPvpLogService.getInstance().add(failGuildPvpLog);
            for (GuildSeasonPvpPlayerParam playerParam : playerParams) {
                GuildPvpPlayerLog guildPvpPlayerLog = new GuildPvpPlayerLog();
                guildPvpPlayerLog.setGuildPvpLogId(guildPvpLogId);
                guildPvpPlayerLog.setGuildInfoId(guildId);
                guildPvpPlayerLog.setGuildInfoName(guildInfo.getGuildName());
                guildPvpPlayerLog.setPlayerName(playerParam.getPlayerName());
                guildPvpPlayerLog.setPlayerUuid(playerParam.getPlayerUuid().toString());
                guildPvpPlayerLog.setKill(playerParam.getKill());
                guildPvpPlayerLog.setDie(playerParam.getIsDeath() != false ? 1 : 0);
                guildPvpPlayerLog.setStartTime(startTime);
                guildPvpPlayerLog.setEndTime(endTime);
                GuildPvpPlayerLogService.getInstance().add(guildPvpPlayerLog);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onGuildSeasonPvpEndBuff(GuildSeasonPvpEndEvent event) {
        if (event.getRank() > 1) {
            return;
        }
        HashMap<UUID, Integer> guildPvpStartPlayerMap = new HashMap<UUID, Integer>(SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP);
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            for (UUID playerUuid : guildPvpStartPlayerMap.keySet()) {
                Optional<Player> guildOnlinePlayerOpt = BaseUtil.getOnlinePlayer(playerUuid);
                if (!guildOnlinePlayerOpt.isPresent()) continue;
                Player guildOnlinePlayer = guildOnlinePlayerOpt.get();
                if (ConfigUtil.KIT_PVP_CONFIG.getBoolean("maxHealth.enable", false)) {
                    Double maxHealth = KitPvpUtil.GUILD_PVP_START_PLAYER_HEALTH_MAP.get(playerUuid);
                    guildOnlinePlayer.setMaxHealth(maxHealth.doubleValue());
                    KitPvpUtil.GUILD_PVP_START_PLAYER_HEALTH_MAP.remove(playerUuid);
                }
                if (PlayerGuild.USE_TITLE && ConfigUtil.KIT_PVP_CONFIG.getBoolean("playerTitleBuff", true)) {
                    PlayerTitleApi.getInstance().setBuff(guildOnlinePlayer);
                    MessageUtil.sendMessage(guildOnlinePlayer, ConfigUtil.KIT_PVP_CONFIG.getString("playerTitleBuffOnMsg"));
                }
                if (PlayerGuild.USE_RACE && ConfigUtil.KIT_PVP_CONFIG.getBoolean("playerRaceBuff", true)) {
                    PlayerRaceApi.getInstance().resetPlayerRace(guildOnlinePlayer);
                    MessageUtil.sendMessage(guildOnlinePlayer, ConfigUtil.KIT_PVP_CONFIG.getString("playerRaceBuffOnMsg"));
                }
                if (ConfigUtil.KIT_PVP_CONFIG.getBoolean("equipment", false)) {
                    LeatherUtil.setPlayerItemStack(guildOnlinePlayer);
                }
                if (PlayerGuild.USE_ADAPT && ConfigUtil.KIT_PVP_CONFIG.getBoolean("adapt", false)) {
                    MessageUtil.sendMessage(guildOnlinePlayer, ConfigUtil.KIT_PVP_CONFIG.getString("adaptOnMsg"));
                }
                BuffManageUtil.callBuffEvent(guildOnlinePlayer);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onGuildSeasonPvpEnd(GuildSeasonPvpEndEvent event) {
        Integer guildId = event.getGuildId();
        List<GuildSeasonPvpPlayerParam> playerParams = event.getPlayerParams();
        Integer rank = event.getRank();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        String content = "all";
        if (rank <= 3) {
            content = rank.toString();
        }
        int guildMoney = ConfigUtil.ACTIVITY_CONFIG.getInt("season.reward." + content + ".guildMoney");
        int guildActive = ConfigUtil.ACTIVITY_CONFIG.getInt("season.reward." + content + ".guildActive");
        int playerMoney = ConfigUtil.ACTIVITY_CONFIG.getInt("season.reward." + content + ".playerMoney");
        String endMsg = ConfigUtil.ACTIVITY_CONFIG.getString("season.endMsg", "${win}");
        String replaceEndMsg = endMsg.replace("${win}", guildInfo.getGuildName()).replace("${rank}", rank.toString()).replace("${guildMoney}", guildMoney + "").replace("${guildActive}", guildActive + "").replace("${playerMoney}", playerMoney + "");
        MessageUtil.sendAllMessage(replaceEndMsg);
        for (GuildSeasonPvpPlayerParam pvpPlayerParam : playerParams) {
            GuildPlayerService.getInstance().addMoneyByName(pvpPlayerParam.getPlayerName(), playerMoney);
        }
        GuildInfoService.getInstance().addMoneyById(guildId, guildMoney);
        GuildInfoService.getInstance().addProsperityDegreeById(guildId, guildActive);
        if (rank == 1) {
            SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.clear();
            SeasonConstants.GUILD_PVP_START_PLAYER_MAP.clear();
            SeasonConstants.START_TIME = null;
            for (UUID playerUuid : SeasonConstants.GUILD_PVP_START_PLAYER_LOCATION_MAP.keySet()) {
                Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(playerUuid);
                if (!onlinePlayerOpt.isPresent()) continue;
                Player player = onlinePlayerOpt.get();
                Location location = SeasonConstants.GUILD_PVP_START_PLAYER_LOCATION_MAP.get(playerUuid);
                GuildPvpEndEventListener.endTp(SeasonConstants.LOOK_LOCATION, location, player);
            }
            SeasonConstants.GUILD_PVP_START_PLAYER_LOCATION_MAP.clear();
            SeasonConstants.LOOK_LOCATION = null;
            return;
        }
        if (rank == 2) {
            for (Integer winGuildId : SeasonConstants.GUILD_PVP_START_PLAYER_MAP.keySet()) {
                List<GuildSeasonPvpPlayerParam> guildSeasonPvpPlayerParams = SeasonConstants.GUILD_PVP_START_PLAYER_MAP.get(winGuildId);
                HandySchedulerUtil.runTaskLater(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildSeasonPvpEndEvent(winGuildId, 1, guildSeasonPvpPlayerParams, event.getSeason())), 20L);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGuildSeasonPvpEndAutoJoin(GuildSeasonPvpEndEvent event) {
        if (event.getRank() > 1) {
            return;
        }
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            List<GuildInfo> guildInfoList = GuildInfoService.getInstance().findAll();
            if (CollUtil.isEmpty(guildInfoList)) {
                return;
            }
            ArrayList<GuildPvp> guildPvpList = new ArrayList<GuildPvp>();
            for (GuildInfo guildInfo : guildInfoList) {
                GuildPvp guildPvp = new GuildPvp();
                guildPvp.setSeason(GuildPvpService.getInstance().findSeason());
                guildPvp.setGuildInfoId(guildInfo.getId());
                guildPvp.setIsJoin(true);
                guildPvp.setIsStart(false);
                guildPvpList.add(guildPvp);
            }
            GuildPvpService.getInstance().batchAdd(guildPvpList);
        });
    }
}

