/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.season;

import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.event.GuildSeasonPvpPreparationEvent;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.expand.adapter.HandyRunnable;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@HandyListener
public class GuildSeasonPvpPreparationEventListener
implements Listener {
    @EventHandler
    public void onGuildSeasonPvpPreparationEvent(final GuildSeasonPvpPreparationEvent event) {
        final List<Integer> guildIdList = event.getGuildIdList();
        for (Integer guildId : guildIdList) {
            SeasonConstants.GUILD_PVP_PREPARATION_MAP.put(guildId, new ArrayList());
        }
        final List<GuildPlayer> guildPlayers = GuildPlayerService.getInstance().findByGuildInfoIds(guildIdList);
        final int[] number = new int[]{0};
        final List<Integer> prepareNumberList = Arrays.asList(1, 10, 20, 30, 50);
        final List<Integer> countDown = Arrays.asList(20, 30, 40, 50, 56, 57, 58, 59, 60);
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                number[0] = number[0] + 1;
                int num = 60 - number[0];
                if (prepareNumberList.contains(number[0])) {
                    for (GuildPlayer guildPlayer : guildPlayers) {
                        Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(guildPlayer.getPlayerName());
                        if (!onlinePlayerOpt.isPresent()) continue;
                        Player guildOnlinePlayer = onlinePlayerOpt.get();
                        List uuidList = SeasonConstants.GUILD_PVP_PREPARATION_MAP.getOrDefault(guildPlayer.getGuildInfoId(), new ArrayList());
                        if (uuidList.contains(guildOnlinePlayer.getUniqueId())) continue;
                        String matePvpPrepareMsg = ConfigUtil.ACTIVITY_CONFIG.getString("season.seasonPvpPrepareMsg", "${time}").replace("${time}", num + "");
                        TextComponent message = new TextComponent(BaseUtil.replaceChatColor(ConfigUtil.ACTIVITY_CONFIG.getString("matePvpPrepareAccept")));
                        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/plg acceptPvp"));
                        TextComponent messageDown = new TextComponent(BaseUtil.replaceChatColor(ConfigUtil.ACTIVITY_CONFIG.getString("matePvpPrepareRefuse")));
                        messageDown.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/plg denyPvp"));
                        message.addExtra((BaseComponent)messageDown);
                        MessageUtil.sendMessage(guildOnlinePlayer, matePvpPrepareMsg);
                        MessageUtil.sendMessage(guildOnlinePlayer, message);
                    }
                }
                if (countDown.contains(number[0])) {
                    for (Integer guild : guildIdList) {
                        List uuidList = SeasonConstants.GUILD_PVP_PREPARATION_MAP.getOrDefault(guild, new ArrayList());
                        for (UUID uuid : uuidList) {
                            Player guildOnlinePlayer = Bukkit.getPlayer((UUID)uuid);
                            if (guildOnlinePlayer == null || !guildOnlinePlayer.isOnline()) continue;
                            String matePvpTitleMsg = ConfigUtil.ACTIVITY_CONFIG.getString("matePvpTitleMsg");
                            String matePvpSubTitleMsg = num > 1 ? ConfigUtil.ACTIVITY_CONFIG.getString("matePvpSubTitleMsg", "${time}").replace("${time}", num + "") : ConfigUtil.ACTIVITY_CONFIG.getString("matePvpSubTitleSTartMsg");
                            MessageUtil.sendTitle(guildOnlinePlayer, matePvpTitleMsg, matePvpSubTitleMsg);
                        }
                    }
                }
                if (number[0] >= 60) {
                    GuildUtil.callGuildSeasonPvpStartEvent(guildIdList, event.getSeason());
                    this.cancel();
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 1L, 20L);
    }
}

