/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildBuff;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.Db;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GuildBuffService {
    private GuildBuffService() {
    }

    public static GuildBuffService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildBuff guildBuff) {
        Db.use(GuildBuff.class).execution().insert(guildBuff);
    }

    public Map<String, GuildBuff> findByGuildId(Integer guildInfoId) {
        Db<GuildBuff> db = Db.use(GuildBuff.class);
        db.where().eq(GuildBuff::getGuildInfoId, guildInfoId);
        List<GuildBuff> list = db.execution().list();
        if (CollUtil.isEmpty(list)) {
            return MapUtil.of();
        }
        return list.stream().collect(Collectors.toMap(GuildBuff::getBuffType, v -> v));
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildBuff> use = Db.use(GuildBuff.class);
        use.where().eq(GuildBuff::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildBuff> findAll() {
        return Db.use(GuildBuff.class).execution().list();
    }

    public void addLevelById(Integer id, Integer number) {
        Db<GuildBuff> use = Db.use(GuildBuff.class);
        use.update().add(GuildBuff::getLevel, GuildBuff::getLevel, number);
        use.execution().updateById(id);
    }

    private static class SingletonHolder {
        private static final GuildBuffService INSTANCE = new GuildBuffService();

        private SingletonHolder() {
        }
    }
}

