/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildEquipment;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import java.util.List;
import java.util.Optional;

public class GuildEquipmentService {
    private GuildEquipmentService() {
    }

    public static GuildEquipmentService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildEquipment guildEquipment) {
        return Db.use(GuildEquipment.class).execution().insert(guildEquipment);
    }

    public void delById(Integer id) {
        Db.use(GuildEquipment.class).execution().deleteById(id);
    }

    public Optional<GuildEquipment> findById(Integer id) {
        return Db.use(GuildEquipment.class).execution().selectById(id);
    }

    public Page<GuildEquipment> page(Integer pageNum, Integer pageSize) {
        Db<GuildEquipment> db = Db.use(GuildEquipment.class);
        db.where().limit(pageNum, pageSize).orderByDesc(GuildEquipment::getId);
        return db.execution().page();
    }

    public List<GuildEquipment> findAll() {
        return Db.use(GuildEquipment.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildEquipmentService INSTANCE = new GuildEquipmentService();

        private SingletonHolder() {
        }
    }
}

