/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildPlayerItem;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.db.Db;
import java.util.List;

public class GuildPlayerItemService {
    private GuildPlayerItemService() {
    }

    public static GuildPlayerItemService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int addAll(List<GuildPlayerItem> guildPlayerItemList) {
        if (CollUtil.isEmpty(guildPlayerItemList)) {
            return 0;
        }
        Db.use(GuildPlayerItem.class).execution().insertBatch(guildPlayerItemList);
        return guildPlayerItemList.size();
    }

    public List<GuildPlayerItem> findByPlayerName(String playerName) {
        Db<GuildPlayerItem> db = Db.use(GuildPlayerItem.class);
        db.where().eq(GuildPlayerItem::getPlayerName, playerName);
        return db.execution().list();
    }

    public void delByPlayerName(String playerName) {
        Db<GuildPlayerItem> db = Db.use(GuildPlayerItem.class);
        db.where().eq(GuildPlayerItem::getPlayerName, playerName);
        db.execution().delete();
    }

    public List<GuildPlayerItem> findAll() {
        return Db.use(GuildPlayerItem.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildPlayerItemService INSTANCE = new GuildPlayerItemService();

        private SingletonHolder() {
        }
    }
}

