/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildShop;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.service.GuildShopLogService;
import java.util.List;
import java.util.Optional;

public class GuildShopService {
    private GuildShopService() {
    }

    public static GuildShopService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildShop guildShop) {
        return Db.use(GuildShop.class).execution().insert(guildShop);
    }

    public void delById(Integer id) {
        Db.use(GuildShop.class).execution().deleteById(id);
        GuildShopLogService.getInstance().delByGuildShopId(id);
    }

    public void delByPlayerName(String playerName) {
        Db<GuildShop> use = Db.use(GuildShop.class);
        use.where().eq(GuildShop::getPlayerName, playerName);
        use.execution().delete();
    }

    public Optional<GuildShop> findById(Integer id) {
        return Db.use(GuildShop.class).execution().selectById(id);
    }

    public Page<GuildShop> page(Integer pageNum, Integer pageSize, List<Integer> guildInfoIds) {
        Db<GuildShop> db = Db.use(GuildShop.class);
        db.where().in(GuildShop::getGuildInfoId, guildInfoIds).limit(pageNum, pageSize).orderByDesc(GuildShop::getId);
        return db.execution().page();
    }

    public void subtractNumberById(Integer id, int number) {
        Db<GuildShop> db = Db.use(GuildShop.class);
        db.update().subtract(GuildShop::getNumber, GuildShop::getNumber, number);
        db.execution().updateById(id);
    }

    public List<GuildShop> findAll() {
        return Db.use(GuildShop.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildShopService INSTANCE = new GuildShopService();

        private SingletonHolder() {
        }
    }
}

