/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.command;

import cn.handyplus.top.constants.TabListEnum;
import cn.handyplus.top.lib.annotation.HandyCommand;
import cn.handyplus.top.lib.command.HandyCommandFactory;
import cn.handyplus.top.lib.util.BaseUtil;
import cn.handyplus.top.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

@HandyCommand(name="playerTop")
public class PlayerTopCommand
implements TabExecutor {
    private static final String PERMISSION = "playerTop.reload";

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length < 1) {
            return this.sendHelp(sender);
        }
        boolean rst = HandyCommandFactory.getInstance().onCommand(sender, cmd, label, args, BaseUtil.getMsgNotColor("noPermission"));
        if (!rst) {
            return this.sendHelp(sender);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<Object> commands = !sender.hasPermission(PERMISSION) ? new ArrayList() : TabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private Boolean sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return true;
        }
        List helps = ConfigUtil.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            sender.sendMessage(BaseUtil.replaceChatColor(help));
        }
        return true;
    }
}

