/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.hook;

import cn.handyplus.top.PlayerTop;
import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class CmiUtil {
    private final Map<Location, CMIHologram> CMI_HD_CACHE = new HashMap<Location, CMIHologram>();

    private CmiUtil() {
    }

    protected static CmiUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void create(List<String> textLineList, Location location) {
        if (!PlayerTop.USE_CMI) {
            return;
        }
        CMIHologram holo = new CMIHologram(UUID.randomUUID().toString(), location);
        holo.setLines(textLineList);
        CMI.getInstance().getHologramManager().addHologram(holo);
        holo.update();
        this.CMI_HD_CACHE.put(location, holo);
    }

    public void delete(Location location) {
        if (!PlayerTop.USE_CMI) {
            return;
        }
        CMIHologram cmiHologram = this.CMI_HD_CACHE.get(location);
        if (cmiHologram != null) {
            cmiHologram.disable();
            cmiHologram.remove();
            this.CMI_HD_CACHE.remove(location);
        }
    }

    public void deleteAll() {
        if (!PlayerTop.USE_CMI) {
            return;
        }
        if (this.CMI_HD_CACHE.isEmpty()) {
            return;
        }
        for (Location location : this.CMI_HD_CACHE.keySet()) {
            CMIHologram cmiHologram = this.CMI_HD_CACHE.get(location);
            if (cmiHologram == null || cmiHologram.getWorld() == null) continue;
            cmiHologram.disable();
            cmiHologram.remove();
        }
        this.CMI_HD_CACHE.clear();
    }

    private static class SingletonHolder {
        private static final CmiUtil INSTANCE = new CmiUtil();

        private SingletonHolder() {
        }
    }
}

