/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.hook;

import cn.handyplus.top.PlayerTop;
import cn.handyplus.top.constants.PlayerTopTypeEnum;
import cn.handyplus.top.enter.TopPapiPlayer;
import cn.handyplus.top.lib.core.StrUtil;
import cn.handyplus.top.service.TopPapiPlayerService;
import cn.handyplus.top.util.ConfigUtil;
import cn.handyplus.top.util.TopUtil;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class PlaceholderUtil
extends PlaceholderExpansion {
    private final PlayerTop plugin;

    public PlaceholderUtil(PlayerTop plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "playerTop";
    }

    public String onRequest(OfflinePlayer player, String placeholder) {
        String originType;
        int pageNum;
        if (player == null) {
            return null;
        }
        String[] placeholderStr = placeholder.split("_");
        if (placeholderStr.length < 2) {
            return "";
        }
        String suffix = placeholderStr[placeholderStr.length - 1];
        if ("rank".equals(suffix)) {
            String type = placeholder.replace("_" + suffix, "");
            type = this.getDataType(type);
            Optional<TopPapiPlayer> topPapiPlayerOptional = TopPapiPlayerService.getInstance().findByUidAndType(player.getUniqueId().toString(), type);
            return topPapiPlayerOptional.map(topPapiPlayer -> topPapiPlayer.getRank().toString()).orElse("0");
        }
        boolean isName = "name".equals(suffix);
        if (isName) {
            pageNum = Integer.parseInt(placeholderStr[placeholderStr.length - 2]);
            originType = placeholder.replace("_" + pageNum + "_" + suffix, "");
        } else {
            pageNum = Integer.parseInt(suffix);
            originType = placeholder.replace("_" + suffix, "");
        }
        String type = this.getDataType(originType);
        Optional<TopPapiPlayer> topPapiPlayerOptional = TopPapiPlayerService.getInstance().findByRankAndType(pageNum, type);
        if (!topPapiPlayerOptional.isPresent()) {
            return "";
        }
        TopPapiPlayer topPapiPlayer2 = topPapiPlayerOptional.get();
        String format = ConfigUtil.FORMAT_CONFIG.getString("format." + originType, "");
        if (type.contains(PlayerTopTypeEnum.MC_MMO.getType())) {
            format = ConfigUtil.FORMAT_CONFIG.getString("format." + PlayerTopTypeEnum.MC_MMO.getType(), "");
        }
        if (type.contains("jobs")) {
            format = ConfigUtil.FORMAT_CONFIG.getString("format.jobs", "");
        }
        String content = StrUtil.isNotEmpty(format) ? TopUtil.getContent(format, topPapiPlayer2) : topPapiPlayer2.getRank().toString();
        return isName ? topPapiPlayer2.getPlayerName() : content;
    }

    private String getDataType(String originType) {
        PlayerTopTypeEnum topTypeEnum = PlayerTopTypeEnum.getType(originType);
        originType = topTypeEnum != null ? topTypeEnum.getType() : "%" + originType + "%";
        return originType;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

