/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.lib.core;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class LockUtil {
    private static final ConcurrentHashMap<String, AtomicInteger> ATOMIC_LOCK_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Long> TIME_LOCK_MAP = new ConcurrentHashMap();
    private static final Map<String, ReentrantLock> REENTRANT_LOCK_MAP = new ConcurrentHashMap<String, ReentrantLock>();
    private static final Integer LOCK_TIME = 350;

    private LockUtil() {
    }

    public static AtomicInteger lock(String key) {
        if (ATOMIC_LOCK_MAP.get(key) == null) {
            ATOMIC_LOCK_MAP.putIfAbsent(key, new AtomicInteger(0));
        }
        ATOMIC_LOCK_MAP.get(key).incrementAndGet();
        return ATOMIC_LOCK_MAP.get(key);
    }

    public static void unLock(String key) {
        ATOMIC_LOCK_MAP.remove(key);
    }

    public static boolean timeLock(UUID key) {
        Long time = TIME_LOCK_MAP.get(key);
        long currentTimeMillis = System.currentTimeMillis();
        if (time == null) {
            TIME_LOCK_MAP.putIfAbsent(key, System.currentTimeMillis());
            return true;
        }
        if (currentTimeMillis - time < (long)LOCK_TIME.intValue()) {
            return false;
        }
        TIME_LOCK_MAP.put(key, currentTimeMillis);
        return true;
    }

    public static void unTimeLock(UUID key) {
        TIME_LOCK_MAP.remove(key);
    }

    public static void reentrantLock(String key) {
        REENTRANT_LOCK_MAP.computeIfAbsent(key, k -> new ReentrantLock(true)).lock();
    }

    public static void unReentrantLock(String key) {
        ReentrantLock lock = REENTRANT_LOCK_MAP.get(key);
        lock.unlock();
        if (lock.getQueueLength() < 1) {
            REENTRANT_LOCK_MAP.remove(key);
        }
    }
}

