/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.lib.core;

import cn.handyplus.top.lib.InitApi;
import cn.handyplus.top.lib.constants.BaseConstants;
import cn.handyplus.top.lib.core.CollUtil;
import cn.handyplus.top.lib.core.HttpUtil;
import cn.handyplus.top.lib.core.MapUtil;
import cn.handyplus.top.lib.core.NetUtil;
import cn.handyplus.top.lib.core.StrUtil;
import cn.handyplus.top.lib.expand.adapter.HandyRunnable;
import cn.handyplus.top.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.top.lib.util.BaseUtil;
import cn.handyplus.top.lib.util.MessageUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.ChatColor;

public class SignUtil {
    private SignUtil() {
    }

    public static void setCommandPermission(boolean rst) {
        SignConstants.COMMAND_PERMISSION = rst;
    }

    public static boolean isGenuine() {
        return SignConstants.RESULT;
    }

    public static boolean isCommandPermission(String command) {
        return SignConstants.COMMAND_PERMISSION && !SignConstants.RESULT && !"getIp".equalsIgnoreCase(command) && !"reload".equalsIgnoreCase(command);
    }

    public static void start() {
        SignParam param = new SignParam();
        param.setPluginName(InitApi.PLUGIN.getName());
        param.setSign(SignConstants.SIGN);
        param.setSecretKey(SignConstants.SECRET_KEY);
        if (CollUtil.isNotEmpty(SignConstants.SUCCEED_MSG)) {
            param.setSucceed(SignConstants.SUCCEED_MSG);
        }
        if (CollUtil.isNotEmpty(SignConstants.FAILURE_MSG)) {
            param.setFailure(SignConstants.FAILURE_MSG);
        }
        SignUtil.start(param);
    }

    private static void start(final SignParam param) {
        if (StrUtil.isEmpty(param.getSecretKey())) {
            return;
        }
        final AtomicInteger retryNumber = new AtomicInteger(6);
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        HashMap<String, String> paramMap = MapUtil.newHashMapWithExpectedSize(5);
                        paramMap.put("sign", param.getSign());
                        paramMap.put("port", InitApi.PLUGIN.getServer().getPort() + "");
                        paramMap.put("pluginName", param.getPluginName());
                        paramMap.put("secretKey", param.getSecretKey());
                        paramMap.put("mac", NetUtil.getLocalMacAddress());
                        String result = HttpUtil.get(SignConstants.VERIFY_SIGN, paramMap);
                        SignUtil.getResult(result, param);
                        this.cancel();
                    }
                    catch (Exception e) {
                        SignConstants.RESULT = false;
                        if (retryNumber.get() < 6 && CollUtil.isNotEmpty(param.getError())) {
                            for (String requestError : param.getError()) {
                                MessageUtil.sendConsoleMessage(BaseUtil.replaceChatColor(requestError));
                            }
                        }
                        retryNumber.getAndDecrement();
                        if (retryNumber.get() < 1) {
                            this.cancel();
                        }
                        if (!BaseConstants.DEBUG) break block5;
                        e.printStackTrace();
                    }
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 20L, 1200L);
    }

    private static void getResult(String result, SignParam param) {
        if (Boolean.TRUE.toString().equals(result)) {
            SignConstants.RESULT = true;
            if (CollUtil.isNotEmpty(param.getSucceed())) {
                for (String verifySignSucceedMsg : param.getSucceed()) {
                    MessageUtil.sendConsoleMessage(BaseUtil.replaceChatColor(verifySignSucceedMsg));
                }
            }
            return;
        }
        SignConstants.RESULT = false;
        if (CollUtil.isNotEmpty(param.getFailure())) {
            for (String verifySignFailureMsg : param.getFailure()) {
                MessageUtil.sendConsoleMessage(BaseUtil.replaceChatColor(verifySignFailureMsg));
            }
        }
    }

    public static class SignParam {
        private String pluginName;
        private String secretKey;
        private String sign;
        private List<String> succeed = Collections.singletonList(ChatColor.GREEN + InitApi.PLUGIN.getName() + "\u63d2\u4ef6\u9a8c\u8bc1\u6210\u529f,\u611f\u8c22\u60a8\u7684\u652f\u6301");
        private List<String> failure = Collections.singletonList(ChatColor.GREEN + InitApi.PLUGIN.getName() + "\u63d2\u4ef6\u672a\u68c0\u6d4b\u5230\u6fc0\u6d3b\u7801,\u8bf7\u8054\u7cfb\u4f5c\u8005\u8d2d\u4e70QQ:956812056");
        private List<String> error = Collections.singletonList(ChatColor.GREEN + InitApi.PLUGIN.getName() + "\u68c0\u6d4b\u5230\u7f51\u7edc\u4e0d\u7a33\u5b9a,\u4e00\u5206\u949f\u540e\u81ea\u52a8\u91cd\u65b0\u9a8c\u8bc1");

        public String getPluginName() {
            return this.pluginName;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getSign() {
            return this.sign;
        }

        public List<String> getSucceed() {
            return this.succeed;
        }

        public List<String> getFailure() {
            return this.failure;
        }

        public List<String> getError() {
            return this.error;
        }

        public void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public void setSucceed(List<String> succeed) {
            this.succeed = succeed;
        }

        public void setFailure(List<String> failure) {
            this.failure = failure;
        }

        public void setError(List<String> error) {
            this.error = error;
        }
    }

    public static class SignConstants {
        public static String SIGN;
        public static String SECRET_KEY;
        public static List<String> SUCCEED_MSG;
        public static List<String> FAILURE_MSG;
        private static boolean RESULT;
        private static boolean COMMAND_PERMISSION;
        private static final String VERIFY_SIGN;
        private static final String DEFAULT_SUCCEED_MSG = "\u63d2\u4ef6\u9a8c\u8bc1\u6210\u529f,\u611f\u8c22\u60a8\u7684\u652f\u6301";
        private static final String DEFAULT_FAILURE_MSG = "\u63d2\u4ef6\u672a\u68c0\u6d4b\u5230\u6fc0\u6d3b\u7801,\u8bf7\u8054\u7cfb\u4f5c\u8005\u8d2d\u4e70QQ:956812056";
        private static final String REQUEST_ERROR_MSG = "\u68c0\u6d4b\u5230\u7f51\u7edc\u4e0d\u7a33\u5b9a,\u4e00\u5206\u949f\u540e\u81ea\u52a8\u91cd\u65b0\u9a8c\u8bc1";

        static {
            RESULT = false;
            COMMAND_PERMISSION = false;
            VERIFY_SIGN = BaseConstants.URL + "/api/public/verifySign";
        }
    }
}

