/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.lib.db;

import cn.handyplus.top.lib.constants.BaseConstants;
import cn.handyplus.top.lib.core.BeanUtil;
import cn.handyplus.top.lib.core.DateUtil;
import cn.handyplus.top.lib.core.NumberUtil;
import cn.handyplus.top.lib.core.StrUtil;
import cn.handyplus.top.lib.db.BaseMapper;
import cn.handyplus.top.lib.db.DbConstant;
import cn.handyplus.top.lib.db.DbSql;
import cn.handyplus.top.lib.db.SqlManagerUtil;
import cn.handyplus.top.lib.db.SqlService;
import cn.handyplus.top.lib.db.enter.Page;
import cn.handyplus.top.lib.db.enums.FieldTypeEnum;
import cn.handyplus.top.lib.db.enums.IndexEnum;
import cn.handyplus.top.lib.db.enums.SqlKeyword;
import cn.handyplus.top.lib.db.param.FieldInfoParam;
import cn.handyplus.top.lib.db.param.TableInfoParam;
import cn.handyplus.top.lib.util.MessageUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DbExecution<T>
implements BaseMapper<T> {
    private final Class<T> clazz;
    private final DbSql dbSql;
    private final String storageMethod;
    private final boolean isMysql;

    protected DbExecution(DbSql dbSql, Class<T> clazz) {
        this.dbSql = dbSql;
        this.clazz = clazz;
        this.storageMethod = BaseConstants.STORAGE_CONFIG.getString("storage-method");
        this.isMysql = "MySQL".equalsIgnoreCase(this.storageMethod);
    }

    protected DbExecution(DbSql dbSql, Class<T> clazz, String storageMethod) {
        this.dbSql = dbSql;
        this.clazz = clazz;
        this.storageMethod = storageMethod;
        this.isMysql = "MySQL".equalsIgnoreCase(storageMethod);
    }

    @Override
    public void create() {
        TableInfoParam tableInfoParam = this.dbSql.getTableInfoParam();
        String createTable = this.isMysql ? "CREATE TABLE IF NOT EXISTS `%s` (`id` INTEGER (11) AUTO_INCREMENT,PRIMARY KEY (`id`)) CHARACTER SET = utf8mb4 ENGINE=INNODB;" : "CREATE TABLE IF NOT EXISTS `%s` ( `id` INTEGER PRIMARY KEY AUTOINCREMENT);";
        String createTableSql = String.format(createTable, tableInfoParam.getTableName());
        MessageUtil.sendConsoleDebugMessage("\u65b0\u589e\u8868sql: " + createTableSql);
        SqlService.getInstance().executionSql(createTableSql, this.storageMethod);
        if (this.isMysql) {
            String tableCommentSql = String.format("ALTER TABLE `%s` COMMENT '%s';", tableInfoParam.getTableName(), tableInfoParam.getTableComment());
            MessageUtil.sendConsoleDebugMessage("\u65b0\u589e\u8868\u6ce8\u91ca: " + tableCommentSql);
            SqlService.getInstance().executionSql(tableCommentSql, this.storageMethod);
        }
        this.addColumn(tableInfoParam.getTableName(), this.dbSql.getFieldInfoMap());
        this.addIndex(tableInfoParam.getTableName());
    }

    @Override
    public void addColumn(String tableName, LinkedHashMap<String, FieldInfoParam> fieldInfoMap) {
        String sql;
        if (this.isMysql) {
            String database = BaseConstants.STORAGE_CONFIG.getString("MySQL.Database");
            sql = String.format("SELECT column_name FROM information_schema.COLUMNS WHERE table_name = '%s' AND table_schema = '%s';", tableName, database);
        } else {
            sql = String.format("PRAGMA table_info ( %s )", tableName);
        }
        MessageUtil.sendConsoleDebugMessage("\u67e5\u8be2\u5b57\u6bb5sql: " + sql);
        List<String> fieldNameList = SqlService.getInstance().getTableInfo(sql, this.storageMethod);
        for (String fieldName : fieldInfoMap.keySet()) {
            String fieldSql;
            FieldInfoParam fieldInfoParam = fieldInfoMap.get(fieldName);
            FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getEnum(fieldInfoParam);
            if (!fieldNameList.contains(fieldName)) {
                String fieldSql2;
                String addColumn;
                String string = addColumn = this.isMysql ? "ALTER TABLE `%s` ADD `%s` %s(%s) %s;" : "ALTER TABLE '%s' ADD '%s' %s(%s) %s;";
                if (this.isMysql) {
                    String string2 = fieldSql2 = fieldInfoParam.getFieldNotNull() != false ? "NOT NULL" : "";
                    if (StrUtil.isNotEmpty(fieldInfoParam.getFieldDefault())) {
                        fieldSql2 = fieldSql2 + String.format(" DEFAULT '%s'", fieldInfoParam.getFieldDefault());
                    }
                } else {
                    String string3 = fieldSql2 = fieldInfoParam.getFieldNotNull() != false ? "NOT NULL" : "";
                    if (StrUtil.isNotEmpty(fieldInfoParam.getFieldDefault())) {
                        fieldSql2 = fieldSql2 + String.format(" DEFAULT '%s'", fieldInfoParam.getFieldDefault());
                    } else if (fieldInfoParam.getFieldNotNull().booleanValue()) {
                        fieldSql2 = fieldSql2 + String.format(" DEFAULT '%s'", "");
                    }
                }
                Integer fieldLength = fieldInfoParam.getFieldLength() != 0 ? fieldInfoParam.getFieldLength() : fieldTypeEnum.getLength();
                String mysqlType = fieldTypeEnum.getMysqlType();
                String fieldLengthStr = fieldLength.toString();
                if (FieldTypeEnum.DOUBLE.getMysqlType().equals(mysqlType) || FieldTypeEnum.BASIC_DOUBLE.getMysqlType().equals(mysqlType)) {
                    fieldLengthStr = fieldLength + ", 2";
                }
                String createFieldSql = String.format(addColumn, tableName, fieldInfoParam.getFieldName(), mysqlType, fieldLengthStr, fieldSql2);
                createFieldSql = createFieldSql.replace("(0)", "");
                MessageUtil.sendConsoleDebugMessage("\u65b0\u589e\u5b57\u6bb5: " + createFieldSql);
                SqlService.getInstance().executionSql(createFieldSql, this.storageMethod);
            }
            if (!this.isMysql) continue;
            String string = fieldSql = fieldInfoParam.getFieldNotNull() != false ? "NOT NULL" : "";
            if ("id".equals(fieldName)) {
                fieldSql = "NOT NULL AUTO_INCREMENT";
            }
            if (StrUtil.isNotEmpty(fieldInfoParam.getFieldDefault())) {
                fieldSql = fieldSql + String.format(" DEFAULT '%s'", fieldInfoParam.getFieldDefault());
            }
            if (StrUtil.isNotEmpty(fieldInfoParam.getFieldComment())) {
                fieldSql = fieldSql + String.format(" COMMENT '%s'", fieldInfoParam.getFieldComment());
            }
            Integer fieldLength = fieldInfoParam.getFieldLength() != 0 ? fieldInfoParam.getFieldLength() : fieldTypeEnum.getLength();
            String mysqlType = fieldTypeEnum.getMysqlType();
            String fieldLengthStr = fieldLength.toString();
            if (FieldTypeEnum.DOUBLE.getMysqlType().equals(mysqlType) || FieldTypeEnum.BASIC_DOUBLE.getMysqlType().equals(mysqlType)) {
                fieldLengthStr = fieldLength + ", 2";
            }
            String fieldCommentSql = String.format("ALTER TABLE `%s` MODIFY `%s` %s(%s) %s;", tableName, fieldInfoParam.getFieldName(), fieldTypeEnum.getMysqlType(), fieldLengthStr, fieldSql);
            fieldCommentSql = fieldCommentSql.replace("(0)", "");
            MessageUtil.sendConsoleDebugMessage("\u65b0\u589e\u5b57\u6bb5\u6ce8\u91ca: " + fieldCommentSql);
            SqlService.getInstance().executionSql(fieldCommentSql, this.storageMethod);
        }
    }

    @Override
    public Optional<T> selectById(Integer id) {
        this.dbSql.addCondition(true, "id", SqlKeyword.EQ, id);
        return this.selectOne();
    }

    @Override
    public List<T> selectBatchIds(List<Integer> ids) {
        this.dbSql.addInCondition(true, "id", SqlKeyword.IN, ids);
        return this.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<T> selectOne() {
        block9: {
            Optional<T> optional;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rst = null;
            String sql = "";
            try {
                conn = SqlManagerUtil.getInstance().getConnection(this.storageMethod);
                sql = this.dbSql.selectDataSql();
                MessageUtil.sendConsoleDebugMessage("selectOne: " + sql);
                ps = conn.prepareStatement(sql);
                rst = ps.executeQuery();
                if (!rst.isBeforeFirst()) {
                    Optional optional2 = Optional.empty();
                    SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
                    return optional2;
                }
                Constructor<T> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                T newInstance = constructor.newInstance(new Object[0]);
                LinkedHashMap<String, FieldInfoParam> fieldInfoMap = this.dbSql.getFieldInfoMap();
                while (rst.next()) {
                    for (String fieldName : fieldInfoMap.keySet()) {
                        FieldInfoParam fieldInfoParam = fieldInfoMap.get(fieldName);
                        Object obj = rst.getObject(fieldInfoParam.getFieldName());
                        if (obj == null) continue;
                        obj = this.specialHandling(fieldInfoParam, obj);
                        Field field = this.clazz.getDeclaredField(fieldInfoParam.getFieldRealName());
                        field.setAccessible(true);
                        field.set(newInstance, obj);
                    }
                }
                optional = Optional.of(newInstance);
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | SQLException e) {
                MessageUtil.sendConsoleMessage("&a selectOne\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38,\u9519\u8befsql:" + sql);
                e.printStackTrace();
                break block9;
            }
            finally {
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            }
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public int count() {
        return this.count(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(String field) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        int count = 0;
        String sql = "";
        try {
            conn = SqlManagerUtil.getInstance().getConnection(this.storageMethod);
            sql = this.dbSql.selectCountSql(field);
            MessageUtil.sendConsoleDebugMessage("count: " + sql);
            ps = conn.prepareStatement(sql);
            rst = ps.executeQuery();
            while (rst.next()) {
                count = rst.getInt(1);
            }
            SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
        }
        catch (SQLException e) {
            MessageUtil.sendConsoleMessage("&a count\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38,\u9519\u8befsql:" + sql);
            e.printStackTrace();
        }
        finally {
            SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> list() {
        ArrayList<T> list;
        block9: {
            ArrayList<T> arrayList;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rst = null;
            list = new ArrayList<T>();
            String sql = "";
            try {
                conn = SqlManagerUtil.getInstance().getConnection(this.storageMethod);
                sql = this.dbSql.selectDataSql();
                MessageUtil.sendConsoleDebugMessage("list: " + sql);
                ps = conn.prepareStatement(sql);
                rst = ps.executeQuery();
                if (!rst.isBeforeFirst()) {
                    ArrayList<T> arrayList2 = list;
                    SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
                    return arrayList2;
                }
                LinkedHashMap<String, FieldInfoParam> fieldInfoMap = this.dbSql.getFieldInfoMap();
                while (rst.next()) {
                    Constructor<T> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    T newInstance = constructor.newInstance(new Object[0]);
                    for (String fieldName : fieldInfoMap.keySet()) {
                        FieldInfoParam fieldInfoParam = fieldInfoMap.get(fieldName);
                        Object obj = rst.getObject(fieldInfoParam.getFieldName());
                        if (obj == null) continue;
                        obj = this.specialHandling(fieldInfoParam, obj);
                        Field field = this.clazz.getDeclaredField(fieldInfoParam.getFieldRealName());
                        field.setAccessible(true);
                        field.set(newInstance, obj);
                    }
                    list.add(newInstance);
                }
                arrayList = list;
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | SQLException e) {
                MessageUtil.sendConsoleMessage("&a List\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38,\u9519\u8befsql:" + sql);
                e.printStackTrace();
                break block9;
            }
            finally {
                SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            }
            return arrayList;
        }
        return list;
    }

    @Override
    public Page<T> page() {
        int count = this.count();
        List<Object> list = new ArrayList();
        if (count > 0) {
            list = this.list();
        }
        return new Page(count, list);
    }

    @Override
    public int insert(T obj) {
        if (this.isMysql) {
            return this.baseInsert(obj);
        }
        try {
            boolean lock = DbConstant.SQLITE_LOCK.tryLock(1L, TimeUnit.MINUTES);
            if (lock) {
                int n = this.baseInsert(obj);
                return n;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbConstant.SQLITE_LOCK.unlock();
        }
        return 0;
    }

    @Override
    public boolean insertBatch(List<T> objList) {
        if (this.isMysql) {
            return this.baseInsertBatch(objList);
        }
        try {
            boolean lock = DbConstant.SQLITE_LOCK.tryLock(1L, TimeUnit.MINUTES);
            if (lock) {
                boolean bl = this.baseInsertBatch(objList);
                return bl;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbConstant.SQLITE_LOCK.unlock();
        }
        return false;
    }

    @Override
    public int updateById(Integer id) {
        this.dbSql.addCondition(true, "id", SqlKeyword.EQ, id);
        return this.update();
    }

    @Override
    public int update() {
        if (this.isMysql) {
            return this.baseUpdate();
        }
        try {
            boolean lock = DbConstant.SQLITE_LOCK.tryLock(1L, TimeUnit.MINUTES);
            if (lock) {
                int n = this.baseUpdate();
                return n;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbConstant.SQLITE_LOCK.unlock();
        }
        return 0;
    }

    @Override
    public int deleteById(Integer id) {
        this.dbSql.addCondition(true, "id", SqlKeyword.EQ, id);
        return this.delete();
    }

    @Override
    public int deleteBatchIds(List<Integer> ids) {
        this.dbSql.addInCondition(true, "id", SqlKeyword.IN, ids);
        return this.delete();
    }

    @Override
    public int delete() {
        if (this.isMysql) {
            return this.baseDelete();
        }
        try {
            boolean lock = DbConstant.SQLITE_LOCK.tryLock(1L, TimeUnit.MINUTES);
            if (lock) {
                int n = this.baseDelete();
                return n;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbConstant.SQLITE_LOCK.unlock();
        }
        return 0;
    }

    private Object specialHandling(FieldInfoParam fieldInfoParam, Object obj) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getEnum(fieldInfoParam);
        switch (fieldTypeEnum) {
            case DATE: {
                if (!this.isMysql) {
                    String str = obj.toString();
                    obj = new Date(Long.parseLong(str));
                    break;
                }
                if (!(obj instanceof LocalDateTime)) break;
                obj = DateUtil.toDate((LocalDateTime)obj);
                break;
            }
            case BOOLEAN: 
            case BASIC_BOOLEAN: {
                if (!(obj instanceof Integer)) break;
                Integer bool = (Integer)obj;
                obj = bool == 1;
                break;
            }
            case LONG: 
            case BASIC_LONG: {
                if (!(obj instanceof Integer)) break;
                Integer number = (Integer)obj;
                obj = number.longValue();
                break;
            }
            case BIG_DECIMAL: {
                Optional<BigDecimal> bigDecimalOptional = NumberUtil.isNumericToBigDecimal(String.valueOf(obj), BigDecimal.ZERO);
                if (!bigDecimalOptional.isPresent()) break;
                obj = bigDecimalOptional.get();
                break;
            }
        }
        return obj;
    }

    private void addIndex(String tableName) {
        if (!this.isMysql) {
            return;
        }
        String showIndexSql = String.format("SHOW INDEX FROM %s;", tableName);
        MessageUtil.sendConsoleDebugMessage("\u67e5\u8be2\u8868\u7d22\u5f15sql: " + showIndexSql);
        List<String> mysqlTableIndexList = SqlService.getInstance().getMysqlTableIndex(showIndexSql, this.storageMethod);
        for (String fieldName : this.dbSql.getFieldInfoMap().keySet()) {
            FieldInfoParam fieldInfoParam = this.dbSql.getFieldInfoMap().get(fieldName);
            if (IndexEnum.NOT.equals((Object)fieldInfoParam.getIndexEnum()) || mysqlTableIndexList.contains(fieldName)) continue;
            String indexName = fieldName;
            indexName = IndexEnum.UNIQUE.equals((Object)fieldInfoParam.getIndexEnum()) ? "un_" + indexName : "idx_" + indexName;
            String addIndexSql = String.format("ALTER TABLE %s ADD INDEX %s (%s);", tableName, indexName, fieldName);
            MessageUtil.sendConsoleDebugMessage("\u65b0\u589e\u8868\u7d22\u5f15: " + addIndexSql);
            SqlService.getInstance().executionSql(addIndexSql, this.storageMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int baseInsert(T obj) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        String sql = "";
        try {
            conn = SqlManagerUtil.getInstance().getConnection(this.storageMethod);
            sql = this.dbSql.insertDataSql();
            MessageUtil.sendConsoleDebugMessage("insert: " + sql);
            ps = conn.prepareStatement(sql, 1);
            Map<String, FieldInfoParam> fieldInfoParamMap = this.dbSql.getFieldInfoMap().values().stream().collect(Collectors.groupingBy(FieldInfoParam::getFieldRealName, Collectors.collectingAndThen(Collectors.toList(), value -> (FieldInfoParam)value.get(0))));
            Map<String, Object> paramMap = BeanUtil.beanToMap(obj);
            for (String key : paramMap.keySet()) {
                FieldInfoParam fieldInfoParam = fieldInfoParamMap.get(key);
                if (fieldInfoParam == null) continue;
                ps.setObject(fieldInfoParam.getFieldIndex(), paramMap.get(key));
            }
            ps.executeUpdate();
            int id = 0;
            rst = ps.getGeneratedKeys();
            if (rst.next()) {
                id = rst.getInt(1);
            }
            int n = id;
            SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
            return n;
        }
        catch (SQLException e) {
            MessageUtil.sendConsoleMessage("&a insert\u51fa\u73b0\u5f02\u5e38,\u9519\u8befsql:" + sql);
            e.printStackTrace();
        }
        finally {
            SqlManagerUtil.getInstance().closeSql(conn, ps, rst);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean baseInsertBatch(List<T> objList) {
        Connection conn = null;
        PreparedStatement ps = null;
        String sql = "";
        try {
            int i;
            conn = SqlManagerUtil.getInstance().getConnection(this.storageMethod);
            sql = this.dbSql.insertDataSql();
            MessageUtil.sendConsoleDebugMessage("insertBatch: " + sql);
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(sql, 1);
            Map<String, FieldInfoParam> fieldInfoParamMap = this.dbSql.getFieldInfoMap().values().stream().collect(Collectors.groupingBy(FieldInfoParam::getFieldRealName, Collectors.collectingAndThen(Collectors.toList(), value -> (FieldInfoParam)value.get(0))));
            for (i = 0; i < objList.size(); ++i) {
                Map<String, Object> paramMap = BeanUtil.beanToMap(objList.get(i));
                for (String key : paramMap.keySet()) {
                    FieldInfoParam fieldInfoParam = fieldInfoParamMap.get(key);
                    if (fieldInfoParam == null) continue;
                    ps.setObject(fieldInfoParam.getFieldIndex(), paramMap.get(key));
                }
                ps.addBatch();
                if (i == 0 || (i + 1) % 500 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            ps.executeBatch();
            conn.commit();
            conn.setAutoCommit(true);
            i = 1;
            SqlManagerUtil.getInstance().closeSql(conn, ps, null);
            return i != 0;
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                    conn.setAutoCommit(true);
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            MessageUtil.sendConsoleMessage("&a insertBatch\u51fa\u73b0\u5f02\u5e38,\u9519\u8befsql:" + sql);
            e.printStackTrace();
        }
        finally {
            SqlManagerUtil.getInstance().closeSql(conn, ps, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int baseUpdate() {
        Connection conn = null;
        PreparedStatement ps = null;
        String sql = "";
        try {
            conn = SqlManagerUtil.getInstance().getConnection(this.storageMethod);
            sql = this.dbSql.updateDataSql();
            MessageUtil.sendConsoleDebugMessage("update: " + sql);
            ps = conn.prepareStatement(sql);
            LinkedHashMap<Integer, Object> updateFieldMap = this.dbSql.getUpdateFieldMap();
            for (Integer index : updateFieldMap.keySet()) {
                ps.setObject(index, updateFieldMap.get(index));
            }
            int n = ps.executeUpdate();
            SqlManagerUtil.getInstance().closeSql(conn, ps, null);
            return n;
        }
        catch (SQLException e) {
            MessageUtil.sendConsoleMessage("&a update\u51fa\u73b0\u5f02\u5e38,\u9519\u8befsql:" + sql);
            e.printStackTrace();
        }
        finally {
            SqlManagerUtil.getInstance().closeSql(conn, ps, null);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int baseDelete() {
        Connection conn = null;
        PreparedStatement ps = null;
        String sql = "";
        try {
            conn = SqlManagerUtil.getInstance().getConnection(this.storageMethod);
            sql = this.dbSql.deleteDataSql();
            MessageUtil.sendConsoleDebugMessage("delete: " + sql);
            ps = conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            SqlManagerUtil.getInstance().closeSql(conn, ps, null);
            return n;
        }
        catch (SQLException e) {
            MessageUtil.sendConsoleMessage("&a delete\u51fa\u73b0\u5f02\u5e38,\u9519\u8befsql:" + sql);
            e.printStackTrace();
        }
        finally {
            SqlManagerUtil.getInstance().closeSql(conn, ps, null);
        }
        return 0;
    }
}

