/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.lib.db.enums;

import cn.handyplus.top.lib.db.param.FieldInfoParam;

public enum FieldTypeEnum {
    STRING("java.lang.String", "VARCHAR", 64),
    DATE("java.util.Date", "DATETIME", 0),
    INTEGER("java.lang.Integer", "INT", 11),
    BASIC_INT("int", "INT", 11),
    LONG("java.lang.Long", "BIGINT", 20),
    BASIC_LONG("long", "BIGINT", 20),
    BOOLEAN("java.lang.Boolean", "INT", 2),
    BASIC_BOOLEAN("boolean", "INT", 2),
    DOUBLE("java.lang.Double", "DOUBLE", 11),
    BASIC_DOUBLE("double", "DOUBLE", 11),
    TEXT("java.lang.String", "TEXT", 0),
    BIG_DECIMAL("java.math.BigDecimal", "VARCHAR", 255);

    private final String javaType;
    private final String mysqlType;
    private final Integer length;

    public static FieldTypeEnum getEnum(FieldInfoParam fieldInfoParam) {
        String javaType = fieldInfoParam.getFieldType();
        Integer fieldLength = fieldInfoParam.getFieldLength();
        if (FieldTypeEnum.STRING.javaType.equals(javaType) && fieldLength >= 16383) {
            return TEXT;
        }
        for (FieldTypeEnum fieldTypeEnum : FieldTypeEnum.values()) {
            if (!fieldTypeEnum.getJavaType().equals(javaType)) continue;
            return fieldTypeEnum;
        }
        return STRING;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getMysqlType() {
        return this.mysqlType;
    }

    public Integer getLength() {
        return this.length;
    }

    private FieldTypeEnum(String javaType, String mysqlType, Integer length) {
        this.javaType = javaType;
        this.mysqlType = mysqlType;
        this.length = length;
    }
}

