/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.command.player;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.lib.command.IHandyCommandEvent;
import cn.handyplus.warp.lib.util.AssertUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.WarpUtil;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TpIdCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "tpId";
    }

    @Override
    public String permission() {
        return "playerWarp.tpId";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getLangMsg("paramFailureMsg"));
        final Integer id = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getLangMsg("amountFailureMsg"));
        final Player player = AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        new BukkitRunnable(){

            public void run() {
                Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(id);
                if (!warpPlayerOptional.isPresent()) {
                    return;
                }
                WarpPlayer warpPlayer = warpPlayerOptional.get();
                if (WarpUtil.tpCheck(player, warpPlayer)) {
                    WarpUtil.runTaskTp(player, warpPlayer);
                }
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

