/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.inventory;

import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.hook.PlayerPointsUtil;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.MapUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpPermissionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class CreateGui {
    private static final CreateGui INSTANCE = new CreateGui();

    private CreateGui() {
    }

    public static CreateGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, OpenParam openParam) {
        String title = ConfigUtil.CREATE_CONFIG.getString("title");
        int size = ConfigUtil.CREATE_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.CREATE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setObj(openParam);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.CREATE.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_CONFIG, inventory, "point", this.replaceMap(player, "point"));
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_CONFIG, inventory, "vault", this.replaceMap(player, "vault"));
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_CONFIG, inventory, "back");
    }

    private Map<String, String> replaceMap(Player player, String type) {
        int money;
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(4);
        String yes = ConfigUtil.CREATE_CONFIG.getString("yesButton");
        String button = ConfigUtil.CREATE_CONFIG.getString("noButton");
        int price = ConfigUtil.CREATE_CONFIG.getInt(type + ".price");
        if ("point".equals(type)) {
            int playerPoints;
            money = playerPoints = PlayerPointsUtil.getPlayerPoints(player);
            if (playerPoints >= price) {
                button = yes;
            }
        } else {
            double playerVault = VaultUtil.getPlayerVault(player);
            money = (int)playerVault;
            if (playerVault >= (double)price) {
                button = yes;
            }
        }
        map.put("price", String.valueOf(price));
        map.put("money", Integer.toString(money));
        int warpNumber = WarpPermissionUtil.getWarpNumber(player);
        Integer count = WarpPlayerService.getInstance().findCount(player.getName());
        map.put("warpNumber", warpNumber >= count ? String.valueOf(warpNumber - count) : "0");
        List notWorldList = ConfigUtil.CONFIG.getStringList("notWorld");
        if (CollUtil.isNotEmpty(notWorldList) && notWorldList.contains(player.getWorld().getName())) {
            button = ConfigUtil.CREATE_CONFIG.getString("noWorldButton");
        }
        map.put("button", button);
        return map;
    }
}

