/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.db;

import cn.handyplus.warp.lib.annotation.TableField;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.db.DbFunction;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DbColumnUtil {
    private DbColumnUtil() {
    }

    public static <T> String getFieldName(DbFunction<T, ?> fn) {
        Field field;
        SerializedLambda serializedLambda;
        Method writeReplaceMethod;
        try {
            writeReplaceMethod = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        boolean isAccessible = writeReplaceMethod.isAccessible();
        writeReplaceMethod.setAccessible(true);
        try {
            serializedLambda = (SerializedLambda)writeReplaceMethod.invoke(fn, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        writeReplaceMethod.setAccessible(isAccessible);
        String fieldName = serializedLambda.getImplMethodName().substring("get".length());
        fieldName = fieldName.replaceFirst(fieldName.charAt(0) + "", (fieldName.charAt(0) + "").toLowerCase());
        try {
            field = Class.forName(serializedLambda.getImplClass().replace("/", ".")).getDeclaredField(fieldName);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        TableField tableField = field.getAnnotation(TableField.class);
        if (tableField == null || StrUtil.isEmpty(tableField.value())) {
            throw new RuntimeException("TableField \u4e3a\u7a7a");
        }
        return tableField.value();
    }
}

