/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.inventory;

import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.util.ItemStackUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class HandyInventoryUtil {
    private HandyInventoryUtil() {
    }

    public static void refreshInventory(Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, new ItemStack(Material.AIR));
        }
    }

    public static int getIndex(FileConfiguration config, String type) {
        return config.getInt(type + ".index", 0);
    }

    public static boolean isIndex(int rawSlot, FileConfiguration config, String type) {
        String indexStrList = config.getString(type + ".index");
        List<Integer> indexList = StrUtil.strToIntList(indexStrList);
        boolean enable = config.getBoolean(type + ".enable", true);
        return enable && indexList.contains(rawSlot);
    }

    public static void setButton(FileConfiguration config, Inventory inventory, String type) {
        HandyInventoryUtil.setButton(config, inventory, type, null);
    }

    public static void setButton(FileConfiguration config, Inventory inventory, String type, Map<String, String> map) {
        HandyInventoryUtil.setButton(config, inventory, type, map, null);
    }

    public static void setButton(FileConfiguration config, Inventory inventory, String type, Map<String, String> map, boolean enchant) {
        HandyInventoryUtil.setButton(config, inventory, type, map, null, enchant);
    }

    public static void setButton(FileConfiguration config, Inventory inventory, String type, Map<String, String> map, Map<String, List<String>> batchMap) {
        HandyInventoryUtil.setButton(config, inventory, type, map, batchMap, false);
    }

    public static void setButton(FileConfiguration config, Inventory inventory, String type, Map<String, String> map, Map<String, List<String>> batchMap, boolean enchant) {
        if (!config.getBoolean(type + ".enable", true)) {
            return;
        }
        String indexStrList = config.getString(type + ".index");
        List<Integer> indexList = StrUtil.strToIntList(indexStrList);
        String name = config.getString(type + ".name");
        int amount = config.getInt(type + ".amount", 1);
        String material = config.getString(type + ".material");
        List<String> loreList = config.getStringList(type + ".lore");
        int customModelDataId = config.getInt(type + ".custom-model-data");
        boolean enchantFlag = enchant || config.getBoolean(type + ".isEnchant");
        boolean hideFlag = config.getBoolean(type + ".hideFlag", true);
        for (Integer index : indexList) {
            loreList = ItemStackUtil.loreBatchReplaceMap(loreList, batchMap, null);
            ItemStack itemStack = ItemStackUtil.getItemStack(material, name, loreList, enchantFlag, customModelDataId, hideFlag, map);
            itemStack.setAmount(amount);
            inventory.setItem(index.intValue(), itemStack);
        }
    }

    public static Optional<Player> getPlayer(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            return Optional.of((Player)humanEntity);
        }
        return Optional.empty();
    }

    public static void setCustomButton(FileConfiguration fileConfig, HandyInventory handyInventory, String parent) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, String> strMap = handyInventory.getStrMap();
        ConfigurationSection configurationSection = fileConfig.getConfigurationSection(parent);
        if (configurationSection == null) {
            return;
        }
        Map values = configurationSection.getValues(false);
        for (String key : values.keySet()) {
            boolean enable;
            MemorySection memorySection = (MemorySection)values.get(key);
            if (memorySection == null || !(enable = memorySection.getBoolean("enable", true))) continue;
            List<Integer> indexList = StrUtil.strToIntList(memorySection.getString("index"));
            String material = memorySection.getString("material");
            String name = memorySection.getString("name");
            List loreList = memorySection.getStringList("lore");
            int customModelDataId = memorySection.getInt("custom-model-data");
            boolean isEnchant = memorySection.getBoolean("isEnchant", false);
            boolean hideFlag = memorySection.getBoolean("hideFlag", true);
            boolean hideEnchant = memorySection.getBoolean("hideEnchant", true);
            String command = memorySection.getString("command");
            for (Integer index : indexList) {
                ItemStack itemStack = ItemStackUtil.getItemStack(material, name, loreList, isEnchant, customModelDataId, hideFlag, null, hideEnchant);
                inventory.setItem(index.intValue(), itemStack);
                if (!StrUtil.isNotEmpty(command)) continue;
                strMap.put(index, command);
            }
        }
    }

    public static Map<Integer, String> getCustomButton(FileConfiguration fileConfig, String parent) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        ConfigurationSection configurationSection = fileConfig.getConfigurationSection(parent);
        if (configurationSection == null) {
            return map;
        }
        Map values = configurationSection.getValues(false);
        for (String key : values.keySet()) {
            boolean enable;
            MemorySection memorySection = (MemorySection)values.get(key);
            if (memorySection == null || !(enable = memorySection.getBoolean("enable", true))) continue;
            List<Integer> indexList = StrUtil.strToIntList(memorySection.getString("index"));
            String command = memorySection.getString("command");
            if (StrUtil.isEmpty(command)) continue;
            for (Integer index : indexList) {
                map.put(index, command);
            }
        }
        return map;
    }

    public static Map<String, String> replacePageMap(HandyInventory handyInventory) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        map.put("count", pageCount == 0 ? "1" : String.valueOf(pageCount));
        map.put("pageNum", String.valueOf(pageNum));
        map.put("nextPage", String.valueOf(pageNum + 1));
        map.put("previousPage", pageNum - 1 < 1 ? "1" : String.valueOf(pageNum - 1));
        return map;
    }
}

