/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.listener.gui;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.inventory.CreateGui;
import cn.handyplus.warp.inventory.LikeGui;
import cn.handyplus.warp.inventory.MeGui;
import cn.handyplus.warp.inventory.OpenGui;
import cn.handyplus.warp.inventory.SelectGui;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpUtil;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpOpenClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.OPEN.getType();
    }

    @Override
    public void rawSlotClick(final HandyInventory handyInventory, final InventoryClickEvent event) {
        final int rawSlot = event.getRawSlot();
        final Integer pageNum = handyInventory.getPageNum();
        final Player player = handyInventory.getPlayer();
        final Integer pageCount = handyInventory.getPageCount();
        final Map<Integer, Integer> map = handyInventory.getIntMap();
        final OpenParam openParam = (OpenParam)handyInventory.getObj();
        new BukkitRunnable(){

            public void run() {
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "previousPage")) {
                    if (pageNum > 1) {
                        handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                        OpenGui.getInstance().setInventoryDate(handyInventory);
                    }
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "nextPage")) {
                    if (pageNum + 1 <= pageCount) {
                        handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                        OpenGui.getInstance().setInventoryDate(handyInventory);
                    }
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "create")) {
                    Inventory inventory = CreateGui.getInstance().createGui(player, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "me")) {
                    Inventory inventory = MeGui.getInstance().createGui(player, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "collection") && !openParam.getIsCollection().booleanValue()) {
                    Inventory inventory = OpenGui.getInstance().createGui(player, OpenParam.builder().isCollection(true).searchType(openParam.getSearchType()).build());
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "all") && openParam.getIsCollection().booleanValue()) {
                    Inventory inventory = OpenGui.getInstance().createGui(player, OpenParam.builder().isCollection(false).searchType(openParam.getSearchType()).build());
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "search")) {
                    WarpTypeEnum nextEnum = WarpTypeEnum.getNextEnum(handyInventory.getSearchType());
                    handyInventory.setSearchType(nextEnum.getType());
                    OpenGui.getInstance().setInventoryDate(handyInventory);
                    return;
                }
                Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.OPEN_CONFIG, "custom");
                String command = custom.get(rawSlot);
                if (StrUtil.isNotEmpty(command)) {
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.chat("/" + command.trim()));
                    return;
                }
                Integer id = (Integer)map.get(rawSlot);
                if (id != null) {
                    if (id == -1) {
                        Inventory inventory = SelectGui.getInstance().createGui(player, openParam, rawSlot);
                        Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                        return;
                    }
                    Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(id);
                    if (!warpPlayerOptional.isPresent()) {
                        return;
                    }
                    WarpPlayer warpPlayer = warpPlayerOptional.get();
                    if (ClickType.LEFT.equals((Object)event.getClick()) && WarpUtil.tpCheck(player, warpPlayer)) {
                        Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> ((Player)player).closeInventory());
                        WarpUtil.runTaskTp(player, warpPlayer);
                    }
                    if (ClickType.RIGHT.equals((Object)event.getClick())) {
                        Inventory inventory = LikeGui.getInstance().createGui(player, id, openParam);
                        Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

