/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.service;

import cn.handyplus.warp.enter.WarpCollection;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.db.Db;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class WarpCollectionService {
    private WarpCollectionService() {
    }

    public static WarpCollectionService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(WarpCollection warpCollection) {
        return Db.use(WarpCollection.class).execution().insert(warpCollection);
    }

    public void delById(Integer id) {
        Db.use(WarpCollection.class).execution().deleteById(id);
    }

    public Optional<WarpCollection> findByPlayerName(String playerName, Integer warpId) {
        Db<WarpCollection> db = Db.use(WarpCollection.class);
        db.where().eq(WarpCollection::getPlayerName, playerName).eq(WarpCollection::getWarpPlayerId, warpId);
        return db.execution().selectOne();
    }

    public List<Integer> findByPlayerName(String playerName) {
        Db<WarpCollection> db = Db.use(WarpCollection.class);
        db.where().eq(WarpCollection::getPlayerName, playerName);
        List<WarpCollection> list = db.execution().list();
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<Integer>();
        }
        return list.stream().map(WarpCollection::getWarpPlayerId).collect(Collectors.toList());
    }

    public void collection(Player player, Integer warpId) {
        Optional<WarpCollection> warpCollectionOptional = this.findByPlayerName(player.getName(), warpId);
        if (!warpCollectionOptional.isPresent()) {
            WarpCollection warpCollection = new WarpCollection();
            warpCollection.setWarpPlayerId(warpId);
            warpCollection.setPlayerName(player.getName());
            warpCollection.setPlayerUuid(player.getUniqueId().toString());
            this.add(warpCollection);
            return;
        }
        this.delById(warpCollectionOptional.get().getId());
    }

    public void deleteByWarpIds(List<Integer> warpIds) {
        Db<WarpCollection> db = Db.use(WarpCollection.class);
        db.where().in(WarpCollection::getWarpPlayerId, warpIds);
        db.execution().delete();
    }

    public List<WarpCollection> findAll() {
        return Db.use(WarpCollection.class).execution().list();
    }

    private static class SingletonHolder {
        private static final WarpCollectionService INSTANCE = new WarpCollectionService();

        private SingletonHolder() {
        }
    }
}

