/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.service;

import cn.handyplus.warp.enter.WarpLikePlayer;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.db.Db;
import java.util.List;
import java.util.Optional;

public class WarpLikePlayerService {
    private WarpLikePlayerService() {
    }

    public static WarpLikePlayerService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(WarpLikePlayer warpLikePlayer) {
        Optional<WarpLikePlayer> warpLikePlayerOptional = this.findByWarpIdAndPlayerName(warpLikePlayer.getWarpPlayerId(), warpLikePlayer.getPlayerName());
        if (warpLikePlayerOptional.isPresent()) {
            this.updateLikeById(warpLikePlayerOptional.get().getId(), warpLikePlayer.getLike());
            return warpLikePlayerOptional.get().getId();
        }
        return Db.use(WarpLikePlayer.class).execution().insert(warpLikePlayer);
    }

    public List<WarpLikePlayer> findByWarpId(Integer warpId) {
        Db<WarpLikePlayer> db = Db.use(WarpLikePlayer.class);
        db.where().eq(WarpLikePlayer::getWarpPlayerId, warpId);
        return db.execution().list();
    }

    public Integer findLikeByWarpId(Integer warpId) {
        List<WarpLikePlayer> warpLikePlayerList = this.findByWarpId(warpId);
        if (CollUtil.isEmpty(warpLikePlayerList)) {
            return 0;
        }
        int sum = warpLikePlayerList.stream().mapToInt(WarpLikePlayer::getLike).sum();
        return sum / warpLikePlayerList.size();
    }

    public void updateLikeById(Integer id, Integer like) {
        Db<WarpLikePlayer> use = Db.use(WarpLikePlayer.class);
        use.update().set(WarpLikePlayer::getLike, like);
        use.execution().updateById(id);
    }

    public Optional<WarpLikePlayer> findByWarpIdAndPlayerName(Integer warpId, String playerName) {
        Db<WarpLikePlayer> db = Db.use(WarpLikePlayer.class);
        db.where().eq(WarpLikePlayer::getPlayerName, playerName).eq(WarpLikePlayer::getWarpPlayerId, warpId);
        return db.execution().selectOne();
    }

    public void deleteByWarpIds(List<Integer> warpIds) {
        Db<WarpLikePlayer> db = Db.use(WarpLikePlayer.class);
        db.where().in(WarpLikePlayer::getWarpPlayerId, warpIds);
        db.execution().delete();
    }

    public List<WarpLikePlayer> findAll() {
        return Db.use(WarpLikePlayer.class).execution().list();
    }

    private static class SingletonHolder {
        private static final WarpLikePlayerService INSTANCE = new WarpLikePlayerService();

        private SingletonHolder() {
        }
    }
}

