/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.mm.MythicMobUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MythicMobGui {
    private static final MythicMobGui INSTANCE = new MythicMobGui();

    private MythicMobGui() {
    }

    public static MythicMobGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.MYTHIC_MOB_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.MYTHIC_MOB_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.MYTHIC_MOB.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.MYTHIC_MOB.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Map<Integer, String> map = handyInventory.getStrMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.MYTHIC_MOB_CONFIG.getString("view.index"));
        handyInventory.setPageSize(indexList.size());
        Map<String, String> mythicMobMap = MythicMobUtil.getInstance().getMythicMobMap(handyInventory.getPageNum() - 1, handyInventory.getPageSize());
        handyInventory.setPageCount(MythicMobUtil.getInstance().getMythicMobsCount());
        if (mythicMobMap.isEmpty()) {
            return;
        }
        String material = ConfigUtil.MYTHIC_MOB_CONFIG.getString("view.material");
        int i = 0;
        for (String displayName : mythicMobMap.keySet()) {
            String internalName = mythicMobMap.get(displayName);
            ItemStack itemStack = ItemStackUtil.getItemStack(material);
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(displayName);
            ArrayList<String> loreList = new ArrayList<String>();
            TaskDemand taskDemand = BaseTaskConstants.MYTHIC_MOBS_MAP.get(player.getUniqueId());
            if (taskDemand != null && StrUtil.isNotEmpty(taskDemand.getItemStack()) && taskDemand.getItemStack().equals(internalName)) {
                ItemStackUtil.setEnchant(itemMeta);
                ItemStackUtil.hideEnchant(itemMeta);
                loreList.add(BaseUtil.getMsgNotColor("selected"));
            }
            itemMeta.setLore(loreList);
            itemStack.setItemMeta(itemMeta);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, internalName);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.MYTHIC_MOB_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.MYTHIC_MOB_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.MYTHIC_MOB_CONFIG, inventory, "step");
        HandyInventoryUtil.setButton(ConfigUtil.MYTHIC_MOB_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.MYTHIC_MOB_CONFIG, inventory, "pane");
    }
}

