/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.inventory.CreateDemandGui;
import com.handy.playertask.inventory.CreateRewardsGui;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class CreateDemandClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.CREATE_DEMAND.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                CreateDemandGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                CreateDemandGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "back")) {
            BaseTaskConstants.TASK_LIST_MAP.remove(player.getUniqueId());
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "search")) {
            handyInventory.setSearchType(DemandTypeEnum.getNextEnum(handyInventory.getSearchType()).getType());
            CreateDemandGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "step")) {
            Inventory inventory = CreateRewardsGui.getInstance().createGui(player, RewardTypeEnum.ALL.getType());
            handyInventory.syncOpen(inventory);
            return;
        }
        Integer taskDemandId = map.get(event.getRawSlot());
        if (taskDemandId == null) {
            return;
        }
        TaskList taskList = BaseTaskConstants.TASK_LIST_MAP.get(player.getUniqueId());
        if (taskList == null) {
            return;
        }
        if (StrUtil.isEmpty(taskList.getTaskDemand())) {
            taskList.setTaskDemand(String.valueOf(taskDemandId));
        } else {
            List<Integer> taskDemandIds = StrUtil.strToIntList(taskList.getTaskDemand());
            if (taskDemandIds.contains(taskDemandId)) {
                taskDemandIds.remove(taskDemandId);
            } else {
                taskDemandIds.add(taskDemandId);
            }
            taskList.setTaskDemand(CollUtil.listToStr(taskDemandIds));
        }
        CreateDemandGui.getInstance().setInventoryDate(handyInventory);
    }
}

