/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskPlayer;
import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.Db;
import com.handy.playertask.lib.db.DbColumnUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.service.TaskPlayerDemandService;
import com.handy.playertask.service.TaskRewardsService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class TaskPlayerService {
    private TaskPlayerService() {
    }

    public static TaskPlayerService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Integer add(TaskPlayer taskPlayer) {
        return Db.use(TaskPlayer.class).execution().insert(taskPlayer);
    }

    public Boolean updateById(Integer id, Boolean status) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.update().set(TaskPlayer::getStatus, status);
        return use.execution().updateById(id) > 0;
    }

    public Page<TaskPlayer> page(UUID playerUuid, Date date, Integer pageNum, Integer pageSize) {
        return this.page(playerUuid, date, null, pageNum, pageSize);
    }

    public int findCountByPlayerAndDate(UUID playerUuid, Date date) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.where().eq(TaskPlayer::getPlayerUuid, playerUuid).eq(TaskPlayer::getTaskDate, date);
        return use.execution().count();
    }

    public Integer findCount(UUID playerUuid, Date date, Boolean status) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.where().eq(TaskPlayer::getPlayerUuid, playerUuid).eq(TaskPlayer::getTaskDate, date).eq(TaskPlayer::getStatus, status);
        return use.execution().count();
    }

    public Optional<TaskPlayer> findById(Integer id) {
        Optional<TaskPlayer> taskPlayerOptional = Db.use(TaskPlayer.class).execution().selectById(id);
        taskPlayerOptional.ifPresent(taskPlayer -> this.setTaskDate(Collections.singletonList(taskPlayer)));
        return taskPlayerOptional;
    }

    public Page<TaskPlayer> page(UUID playerUuid, Date date, Boolean status, Integer pageNum, Integer pageSize) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.where().eq(TaskPlayer::getPlayerUuid, playerUuid).eq(TaskPlayer::getTaskDate, date).limit(pageNum, pageSize).eq(status != null, TaskPlayer::getStatus, status);
        Page<TaskPlayer> page = use.execution().page();
        this.setTaskDate(page.getRecords());
        return page;
    }

    public int findByDoneStatus(UUID playerUuid, Date date) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.where().eq(TaskPlayer::getPlayerUuid, playerUuid).eq(TaskPlayer::getTaskDate, date).eq(TaskPlayer::getStatus, true);
        return use.execution().count();
    }

    public int findTaskRefresh(UUID playerUuid, Date date) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.where().eq(TaskPlayer::getPlayerUuid, playerUuid).eq(TaskPlayer::getTaskDate, date).limit(1, 1);
        Optional<TaskPlayer> taskPlayerOptional = use.execution().selectOne();
        if (!taskPlayerOptional.isPresent()) {
            return 0;
        }
        TaskPlayer taskPlayer = taskPlayerOptional.get();
        return taskPlayer.getRefresh() != null ? taskPlayer.getRefresh() : 0;
    }

    private void setTaskDate(List<TaskPlayer> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List<Integer> idsList = list.stream().map(TaskPlayer::getId).collect(Collectors.toList());
        List<TaskPlayerDemand> taskPlayerDemands = TaskPlayerDemandService.getInstance().findByTaskPlayerIds(idsList);
        Map<Integer, List<TaskPlayerDemand>> taskPlayerDemandMap = taskPlayerDemands.stream().collect(Collectors.groupingBy(TaskPlayerDemand::getTaskPlayerId));
        List<Integer> taskIdsList = list.stream().map(TaskPlayer::getTaskId).collect(Collectors.toList());
        List<TaskList> taskListList = TaskListService.getInstance().findByIds(taskIdsList);
        Map<Integer, TaskList> taskListMap = taskListList.stream().collect(Collectors.groupingBy(TaskList::getId, Collectors.collectingAndThen(Collectors.toList(), value -> (TaskList)value.get(0))));
        ArrayList<Integer> rewardList = new ArrayList<Integer>();
        for (TaskPlayer taskPlayer : list) {
            taskPlayer.setTaskPlayerDemands(taskPlayerDemandMap.get(taskPlayer.getId()));
            TaskList taskList = taskListMap.get(taskPlayer.getTaskId());
            if (taskList != null) {
                taskPlayer.setRarity(taskList.getRarity());
                taskPlayer.setDescription(taskList.getDescription());
            }
            if (!StrUtil.isNotEmpty(taskPlayer.getTaskRewards())) continue;
            rewardList.addAll(StrUtil.strToIntList(taskPlayer.getTaskRewards()));
        }
        List<TaskRewards> taskRewardList = TaskRewardsService.getInstance().findByIds(rewardList);
        if (CollUtil.isNotEmpty(taskRewardList)) {
            Map<Integer, TaskRewards> taskRewardsMap = taskRewardList.stream().collect(Collectors.groupingBy(TaskRewards::getId, Collectors.collectingAndThen(Collectors.toList(), value -> (TaskRewards)value.get(0))));
            for (TaskPlayer taskPlayer : list) {
                if (!StrUtil.isNotEmpty(taskPlayer.getTaskRewards())) continue;
                ArrayList<TaskRewards> taskRewardsList = new ArrayList<TaskRewards>();
                List<Integer> rewardIds = StrUtil.strToIntList(taskPlayer.getTaskRewards());
                for (Integer rewardId : rewardIds) {
                    TaskRewards taskRewards = taskRewardsMap.get(rewardId);
                    if (taskRewards == null) continue;
                    taskRewardsList.add(taskRewards);
                }
                taskPlayer.setTaskRewardsList(CollUtil.isNotEmpty(taskRewardsList) ? taskRewardsList : null);
            }
        }
    }

    public void deleteByTaskId(Integer taskId) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.where().eq(TaskPlayer::getTaskId, taskId);
        use.execution().delete();
    }

    public void deleteByPlayer(UUID playerUuid) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.where().eq(TaskPlayer::getPlayerUuid, playerUuid);
        use.execution().delete();
    }

    public void deleteAll() {
        Db.use(TaskPlayer.class).execution().delete();
    }

    public Integer findCountDistinctPlayer(Date date) {
        Db<TaskPlayer> use = Db.use(TaskPlayer.class);
        use.where().eq(TaskPlayer::getTaskDate, date);
        return use.execution().count(DbColumnUtil.getFieldName(TaskPlayer::getPlayerUuid));
    }

    private static class SingletonHolder {
        private static final TaskPlayerService INSTANCE = new TaskPlayerService();

        private SingletonHolder() {
        }
    }
}

