/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.constants.particle;

import com.handy.playertitle.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum SuperTrailsEnum {
    HEART(1, BaseUtil.getLangMsg("superTrails.heart")),
    ANGRY(2, BaseUtil.getLangMsg("superTrails.angry")),
    MAGIC(3, BaseUtil.getLangMsg("superTrails.magic")),
    COLORS(4, BaseUtil.getLangMsg("superTrails.colors")),
    CLOUDS(5, BaseUtil.getLangMsg("superTrails.clouds")),
    WITCH(6, BaseUtil.getLangMsg("superTrails.witch")),
    ENDER(7, BaseUtil.getLangMsg("superTrails.ender")),
    GREEN(8, BaseUtil.getLangMsg("superTrails.green")),
    SPARK(9, BaseUtil.getLangMsg("superTrails.spark")),
    FLAME(10, BaseUtil.getLangMsg("superTrails.flame")),
    WHITE(11, BaseUtil.getLangMsg("superTrails.white")),
    NOTE(12, BaseUtil.getLangMsg("superTrails.note")),
    SNOW(13, BaseUtil.getLangMsg("superTrails.snow")),
    WATER(14, BaseUtil.getLangMsg("superTrails.water")),
    LAVA(15, BaseUtil.getLangMsg("superTrails.lava")),
    CRIT(16, BaseUtil.getLangMsg("superTrails.crit")),
    SMOKE(17, BaseUtil.getLangMsg("superTrails.smoke")),
    SPELL(18, BaseUtil.getLangMsg("superTrails.spell")),
    ENCHANT(19, BaseUtil.getLangMsg("superTrails.enchant")),
    SPLASH(20, BaseUtil.getLangMsg("superTrails.splash")),
    SLIME(21, BaseUtil.getLangMsg("superTrails.slime")),
    SNOWBALLS(22, BaseUtil.getLangMsg("superTrails.snowballs")),
    SPELL_23(23, BaseUtil.getLangMsg("superTrails.spell_23")),
    VOID(25, BaseUtil.getLangMsg("superTrails.void")),
    LAVA_POP(26, BaseUtil.getLangMsg("superTrails.lava_pop")),
    RAINBOW_WINGS_1_9(27, BaseUtil.getLangMsg("superTrails.rainbow_wings_1_9")),
    DRAGON_BREATH_1_9(28, BaseUtil.getLangMsg("superTrails.dragon_breath_1_9")),
    ENDROD_1_9(29, BaseUtil.getLangMsg("superTrails.endrod_1_9")),
    DAMAGE_1_9(30, BaseUtil.getLangMsg("superTrails.damage_1_9")),
    SAND_1_10(31, BaseUtil.getLangMsg("superTrails.sand_1_10")),
    TOTEM_1_11(32, BaseUtil.getLangMsg("superTrails.totem_1_11")),
    WINGS_ANGEL(55, BaseUtil.getLangMsg("superTrails.wings_angel")),
    WINGS_BUTTERFLY(56, BaseUtil.getLangMsg("superTrails.wings_butterfly")),
    RBUILDER(199, BaseUtil.getLangMsg("superTrails.rbuilder")),
    GLASS_B(100, BaseUtil.getLangMsg("superTrails.glass_b")),
    FLOWER_B(101, BaseUtil.getLangMsg("superTrails.flower_b")),
    CARPET_B(102, BaseUtil.getLangMsg("superTrails.carpet_b")),
    REDSTN_B(103, BaseUtil.getLangMsg("superTrails.redstn_b")),
    SEA_B(104, BaseUtil.getLangMsg("superTrails.sea_b")),
    WHEAT_B(105, BaseUtil.getLangMsg("superTrails.wheat_b")),
    ORE_B(106, BaseUtil.getLangMsg("superTrails.ore_b")),
    CLAY_B(107, BaseUtil.getLangMsg("superTrails.clay_b")),
    TEAR_R(200, BaseUtil.getLangMsg("superTrails.tear_r")),
    BLOOD_R(201, BaseUtil.getLangMsg("superTrails.blood_r")),
    DIA_R(202, BaseUtil.getLangMsg("superTrails.dia_r")),
    WART_R(203, BaseUtil.getLangMsg("superTrails.wart_r")),
    GOLD_R(204, BaseUtil.getLangMsg("superTrails.gold_r"));

    private final Integer id;
    private final String name;

    public static String getName(Integer id) {
        for (SuperTrailsEnum superTrailsEnum : SuperTrailsEnum.values()) {
            if (!superTrailsEnum.getId().equals(id)) continue;
            return superTrailsEnum.getName();
        }
        return null;
    }

    public static List<String> getSuperTrails() {
        ArrayList<String> trailsNames = new ArrayList<String>();
        SuperTrailsEnum[] values = SuperTrailsEnum.values();
        Arrays.sort(values, (x, y) -> y.getId() - x.getId());
        for (SuperTrailsEnum superTrailsEnum : values) {
            if (superTrailsEnum == null) continue;
            String trailsName = superTrailsEnum.getId() + "(" + superTrailsEnum.getName() + ")";
            trailsNames.add(trailsName);
        }
        return trailsNames;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    private SuperTrailsEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }
}

