/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.attribute;

import com.handy.playertitle.lib.attribute.AttributeEnum;
import com.handy.playertitle.lib.attribute.AttributePlusUtil;
import com.handy.playertitle.lib.attribute.AttributePlusV2Util;
import com.handy.playertitle.lib.attribute.AttributeSystemUtil;
import com.handy.playertitle.lib.attribute.MmoItemsUtil;
import com.handy.playertitle.lib.attribute.MythicLibUtil;
import com.handy.playertitle.lib.attribute.PotionEffectUtil;
import com.handy.playertitle.lib.attribute.SxAttributeUtil;
import com.handy.playertitle.lib.attribute.SxAttributeV2Util;
import com.handy.playertitle.lib.util.BaseUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AttributeUtil {
    private static boolean USE_AP_3;
    private static boolean USE_AP_2;
    private static boolean USE_AS;
    private static boolean USE_SX_3;
    private static boolean USE_SX_2;
    private static boolean USE_MMO;
    private static boolean USE_MYTHIC;
    private static final AttributeUtil INSTANCE;

    private AttributeUtil() {
    }

    public static AttributeUtil getInstance() {
        AttributeUtil.init();
        return INSTANCE;
    }

    public void addAttribute(Player player, List<String> attributeList, AttributeEnum attributeEnum) {
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        if (player == null) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: player\u4e0d\u80fd\u4e3anull");
        }
        attributeList = BaseUtil.replaceChatColor(attributeList);
        switch (attributeEnum) {
            case ATTRIBUTE_PLUS: {
                if (USE_AP_3) {
                    AttributePlusUtil.addAttribute(player, attributeList);
                }
                if (!USE_AP_2) break;
                AttributePlusV2Util.addAttribute(player, attributeList);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.addAttribute(player, attributeList);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.addAttribute(player, attributeList);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.addAttribute(player, attributeList);
                break;
            }
            case MMO_ITEMS: {
                if (!USE_MMO) break;
                MmoItemsUtil.getInstance().addAttribute(player, attributeList);
                break;
            }
            case POTION_EFFECT: {
                PotionEffectUtil.addAttribute(player, attributeList);
                break;
            }
            case MYTHIC_LIB: {
                if (!USE_MYTHIC) break;
                MythicLibUtil.addAttribute(player, attributeList);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    public void removeAttribute(Player player, AttributeEnum attributeEnum) {
        switch (attributeEnum) {
            case ALL: {
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute(player);
                }
                if (USE_AP_2) {
                    AttributePlusV2Util.removeAttribute(player);
                }
                if (USE_AS) {
                    AttributeSystemUtil.removeAttribute(player);
                }
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute(player);
                }
                if (USE_SX_2) {
                    SxAttributeV2Util.removeAttribute(player);
                }
                if (USE_MMO) {
                    MmoItemsUtil.getInstance().removeAttribute(player);
                }
                if (USE_MYTHIC) {
                    MythicLibUtil.removeAttribute(player);
                }
                PotionEffectUtil.removeAttribute(player);
                break;
            }
            case ATTRIBUTE_PLUS: {
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute(player);
                }
                if (!USE_AP_2) break;
                AttributePlusV2Util.removeAttribute(player);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.removeAttribute(player);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute(player);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.removeAttribute(player);
                break;
            }
            case MMO_ITEMS: {
                if (!USE_MMO) break;
                MmoItemsUtil.getInstance().removeAttribute(player);
                break;
            }
            case POTION_EFFECT: {
                PotionEffectUtil.removeAttribute(player);
                break;
            }
            case MYTHIC_LIB: {
                if (!USE_MYTHIC) break;
                MythicLibUtil.removeAttribute(player);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    private static void init() {
        USE_AS = BaseUtil.hook("AttributeSystem").isPresent();
        Optional<Plugin> sxPluginOpt = BaseUtil.hook("SX-Attribute");
        if (sxPluginOpt.isPresent()) {
            if (BaseUtil.getFirstPluginVersion(sxPluginOpt.get()) < 3) {
                USE_SX_2 = true;
            } else {
                USE_SX_3 = true;
            }
        } else {
            USE_SX_2 = false;
            USE_SX_3 = false;
        }
        Optional<Plugin> apPluginOpt = BaseUtil.hook("AttributePlus");
        if (apPluginOpt.isPresent()) {
            if (BaseUtil.getFirstPluginVersion(apPluginOpt.get()) < 3) {
                USE_AP_2 = true;
            } else {
                USE_AP_3 = true;
            }
        } else {
            USE_AP_2 = false;
            USE_AP_3 = false;
        }
        Optional<Plugin> mmoItems = BaseUtil.hook("MMOItems");
        if (mmoItems.isPresent()) {
            USE_MMO = true;
            MmoItemsUtil.getInstance();
        } else {
            USE_MMO = false;
        }
        USE_MYTHIC = BaseUtil.hook("MythicLib").isPresent();
        if (USE_MYTHIC) {
            USE_MYTHIC = MythicLibUtil.isNewVersion();
        }
    }

    static {
        INSTANCE = new AttributeUtil();
    }
}

