/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener;

import com.handy.playertitle.api.PlayerTitleApi;
import com.handy.playertitle.lib.annotation.HandyListener;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.util.ConfigUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

@HandyListener
public class PlayerTeleportEventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerTeleportEvent(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getTo() == null) {
            return;
        }
        World world = event.getTo().getWorld();
        if (world == null) {
            return;
        }
        List disabledBuffWorldList = ConfigUtil.CONFIG.getStringList("disabledBuffWorld");
        if (CollUtil.isEmpty(disabledBuffWorldList = disabledBuffWorldList.stream().filter(StrUtil::isNotEmpty).collect(Collectors.toList()))) {
            return;
        }
        if (disabledBuffWorldList.contains(world.getName())) {
            PlayerTitleApi.getInstance().removeBuff(event.getPlayer());
            String playerTitleBuffOffMsg = ConfigUtil.LANG_CONFIG.getString("playerTitleBuffOffMsg");
            playerTitleBuffOffMsg = StrUtil.replace(playerTitleBuffOffMsg, "world", world.getName());
            MessageUtil.sendMessage(event.getPlayer(), playerTitleBuffOffMsg);
        } else {
            PlayerTitleApi.getInstance().setBuff(event.getPlayer());
        }
    }
}

