/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.annotation.HandyListener;
import com.handy.playertitle.lib.constants.VersionCheckEnum;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.DateUtil;
import com.handy.playertitle.lib.core.LockUtil;
import com.handy.playertitle.lib.core.SignUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.param.TitleCardParam;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.TitleMessageUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class TitleCardListener
implements Listener {
    @EventHandler
    public void onInteractEvent(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item == null || !Material.PAPER.equals((Object)item.getType()) || item.getItemMeta() == null || StrUtil.isEmpty(item.getItemMeta().getDisplayName())) {
            return;
        }
        Player player = event.getPlayer();
        if (VersionCheckEnum.getEnum().getVersionId() > VersionCheckEnum.V_1_8.getVersionId() && !EquipmentSlot.HAND.equals((Object)event.getHand())) {
            return;
        }
        boolean timeLock = LockUtil.timeLock(event.getPlayer().getUniqueId());
        if (!timeLock) {
            return;
        }
        if (item.getItemMeta().getDisplayName().contains(BaseUtil.getLangMsg("changeItem.titleCard"))) {
            this.getTitleCard(player, item);
            return;
        }
        if (item.getItemMeta().getDisplayName().contains(BaseUtil.getLangMsg("randomCard.titleCard"))) {
            this.getRandomCard(player, item);
        }
    }

    private void getTitleCard(Player player, ItemStack item) {
        Integer oneHundredId;
        TitleCardParam titleCardParam = TitleUtil.getCardData(item);
        Integer titleId = titleCardParam.getId();
        Integer day = titleCardParam.getDay();
        if (titleId == null || day == null) {
            return;
        }
        Optional<TitlePlayer> titlePlayerOptional = TitlePlayerService.getInstance().findByPlayerNameAndTitleId(player.getName(), titleId);
        if (titlePlayerOptional.isPresent() && DateUtil.isPerpetual(titlePlayerOptional.get().getExpirationTime())) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("titleExistMsg"));
            return;
        }
        if (!ItemStackUtil.removeItem(player.getInventory(), item, 1).booleanValue()) {
            return;
        }
        Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(titleId);
        if (!titleListOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("changeItem.noTitleFailureMsg"));
            return;
        }
        TitleList titleList = titleListOptional.get();
        if (!SignUtil.isGenuine() && (oneHundredId = TitleListService.getInstance().findOneHundredCount()) > 0 && titleId >= oneHundredId) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("randomCard.noTitleMsg"));
            return;
        }
        TitlePlayer titlePlayer = new TitlePlayer();
        titlePlayer.setPlayerName(player.getName());
        titlePlayer.setPlayerUuid(player.getUniqueId().toString());
        titlePlayer.setTitleId(titleId);
        titlePlayer.setTitleName(titleList.getTitleName());
        titlePlayer.setIsUseShow(false);
        titlePlayer.setIsUseBuff(false);
        titlePlayer.setIsUseParticle(false);
        titlePlayer.setExpirationTime(DateUtil.getDate(day != 0 ? day : 36500));
        boolean rst = TitlePlayerService.getInstance().set(titlePlayer);
        if (rst) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("changeItem.useTitleCardSucceedMsg"));
            TitleMessageUtil.sendMsg(titleList.getId(), titleList.getTitleName(), player.getName());
        } else {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("changeItem.useTitleCardFailureMsg"));
        }
    }

    private void getRandomCard(Player player, ItemStack item) {
        Integer oneHundredId;
        TitleCardParam titleCardParam = TitleUtil.getCardData(item);
        Integer buyTypeId = titleCardParam.getId();
        Integer day = titleCardParam.getDay();
        if (buyTypeId == null || day == null) {
            return;
        }
        if (!ItemStackUtil.removeItem(player.getInventory(), item, 1).booleanValue()) {
            return;
        }
        BuyTypeEnum buyType = BuyTypeEnum.getEnum(buyTypeId);
        if (buyType == null) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("buyTypeFailureMsg") + " " + buyTypeId);
            return;
        }
        List<Integer> ids = TitleListService.getInstance().findByBuyType(buyType.getBuyType());
        if (CollUtil.isEmpty(ids)) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("randomCard.noTitle"));
            return;
        }
        Random random = new Random();
        int titleId = random.nextInt(ids.size());
        Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(titleId);
        if (!titleListOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("randomCard.noTitleMsg"));
            return;
        }
        TitleList titleList = titleListOptional.get();
        Optional<TitlePlayer> titlePlayerOptional = TitlePlayerService.getInstance().findByPlayerNameAndTitleId(player.getName(), titleList.getId());
        if (titlePlayerOptional.isPresent() && DateUtil.isPerpetual(titlePlayerOptional.get().getExpirationTime())) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("titleExistMsg"));
            return;
        }
        if (!SignUtil.isGenuine() && (oneHundredId = TitleListService.getInstance().findOneHundredCount()) > 0 && titleId >= oneHundredId) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("randomCard.noTitleMsg"));
            return;
        }
        TitlePlayer titlePlayer = new TitlePlayer();
        titlePlayer.setPlayerName(player.getName());
        titlePlayer.setPlayerUuid(player.getUniqueId().toString());
        titlePlayer.setTitleId(titleList.getId());
        titlePlayer.setTitleName(titleList.getTitleName());
        titlePlayer.setIsUseShow(false);
        titlePlayer.setIsUseBuff(false);
        titlePlayer.setIsUseParticle(false);
        titlePlayer.setExpirationTime(DateUtil.getDate(day != 0 ? day : 36500));
        boolean rst = TitlePlayerService.getInstance().set(titlePlayer);
        if (rst) {
            String langMsg = BaseUtil.getLangMsg("randomCard.useTitleCardSucceedMsg");
            String newDay = day != 0 ? day + BaseUtil.getLangMsg("shop.day") : BaseUtil.getLangMsg("perpetual");
            langMsg = langMsg.replace("${titleCard}", PlaceholderApiUtil.set(player, titleList.getTitleName())).replace("${day}", newDay);
            MessageUtil.sendMessage(player, langMsg);
            TitleMessageUtil.sendMsg(titleList.getId(), titleList.getTitleName(), player.getName());
        } else {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("randomCard.useTitleCardFailureMsg"));
        }
    }
}

