/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.inventory.AdminShopGui;
import com.handy.playertitle.inventory.HavePlayerGui;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class HavePlayerClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.ADMIN_SHOP_PLAYER.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                HavePlayerGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                HavePlayerGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "back")) {
            Inventory inventory = AdminShopGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.OPEN_CONFIG.getString("open.index"));
        if (indexList.contains(rawSlot)) {
            Integer id = map.get(event.getRawSlot());
            TitlePlayerService.getInstance().removeById(id);
            HavePlayerGui.getInstance().setInventoryDate(handyInventory);
        }
    }
}

