/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.inventory.AdminShopGui;
import com.handy.playertitle.inventory.ViewShopGui;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class ViewShopGuiClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.VIEW_SHOP.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        if (rawSlot == HandyInventoryUtil.getIndex(ConfigUtil.VIEW_SHOP_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                ViewShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (rawSlot == HandyInventoryUtil.getIndex(ConfigUtil.VIEW_SHOP_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                ViewShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (rawSlot == HandyInventoryUtil.getIndex(ConfigUtil.VIEW_SHOP_CONFIG, "search")) {
            String nextSearchType = BuyTypeEnum.getNextEnum(handyInventory.getSearchType());
            handyInventory.setSearchType(nextSearchType);
            ViewShopGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.OPEN_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            PlayerSchedulerUtil.syncPerformCommand(player, command);
            return;
        }
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.VIEW_SHOP_CONFIG.getString("shop.index"));
        if (indexList.contains(rawSlot) && map.get(rawSlot) != null) {
            Inventory inventory = AdminShopGui.getInstance().createGui(player, map.get(rawSlot));
            handyInventory.syncOpen(inventory);
        }
    }
}

