/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.items;

import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.items.ItemManager;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillManager;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Artifact {
    private MythicItem item;
    private MythicConfig mc;
    private boolean cancelDamage = false;
    private boolean preventDropping = false;
    private boolean preventRenaming = true;
    private boolean destroyOnDrop = false;
    private boolean keepOnDeath = false;
    private boolean destroy = false;
    private Optional<String> permission = Optional.empty();
    private Optional<String> itemTypeOverride = Optional.empty();
    private Map<SkillTrigger, Queue<SkillMechanic>> mechanics = new HashMap<SkillTrigger, Queue<SkillMechanic>>();
    private Queue<SkillMechanic> timerMechanics = null;
    private boolean useAmmoSystem;
    private Optional<MythicItem> ammoType = Optional.empty();
    private final int ammoClipSize;
    private final int ammoPerItem;
    private int ammoLoreLine;

    public Artifact(MythicItem item) {
        this.item = item;
        this.mc = item.getConfig();
        this.cancelDamage = this.mc.getBoolean("Options.CancelDamage", this.cancelDamage);
        this.preventDropping = this.mc.getBoolean("Options.PreventDropping", false);
        this.preventRenaming = this.mc.getBoolean("Options.PreventRenaming", true);
        this.destroy = this.mc.getBoolean("Options.Destroy", false);
        this.destroyOnDrop = this.mc.getBoolean("Options.DestroyOnDrop", false);
        this.keepOnDeath = this.mc.getBoolean("Options.KeepOnDeath", false);
        this.permission = Optional.ofNullable(this.mc.getString("Options.Permission", null));
        this.itemTypeOverride = Optional.ofNullable(this.mc.getString("Options.SkillType", null));
        if (this.itemTypeOverride.isPresent()) {
            this.item.setMythicType(this.itemTypeOverride.get());
        }
        this.useAmmoSystem = this.mc.getBoolean("Ammo.Enabled", false);
        this.ammoClipSize = this.mc.getInteger("Ammo.ClipSize", 1);
        this.ammoPerItem = this.mc.getInteger("Ammo.AmmoPerItem", 1);
        String ammoType = this.mc.getString("Ammo.Bullet", "Bullet");
        if (this.useAmmoSystem) {
            Artifacts.inst().getItemManager().queueSecondPass(() -> {
                Optional bullet = MythicMobs.inst().getItemManager().getItem(ammoType);
                if (bullet.isPresent()) {
                    this.ammoType = bullet;
                } else {
                    Artifacts.error("Could not find bullet type '" + ammoType + "' for item " + this.item.getInternalName());
                    this.useAmmoSystem = false;
                }
            });
            this.ammoLoreLine = 0;
            boolean found = false;
            for (String lore : item.getLore()) {
                Matcher valueMatcher = ItemManager.AmmunitionRegex.matcher(lore);
                if (valueMatcher.find()) {
                    found = true;
                    break;
                }
                ++this.ammoLoreLine;
            }
            if (!found) {
                Artifacts.error("Could not find required Ammo lore line for item " + this.item.getInternalName());
                this.useAmmoSystem = false;
            }
        }
        SkillManager sm = MythicMobs.inst().getSkillManager();
        List skills = this.mc.getStringList("Skills");
        if (skills.size() > 0) {
            this.item.setAppendType(Boolean.valueOf(true));
        }
        for (String s : skills) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Loading mechanic line: {0}", (Object[])new Object[]{s});
            s = MythicLineConfig.unparseBlock((String)s);
            SkillMechanic ms = MythicMobs.inst().getSkillManager().getSkillMechanic(s);
            int interval = 1;
            if (ms != null) {
                Matcher Rmatcher;
                Pattern Rpattern;
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Base skill found.", (Object[])new Object[0]);
                if (s.contains("~onTimer")) {
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is Timer. Assigning skill to Timer...", (Object[])new Object[0]);
                    Rpattern = Pattern.compile("~onTimer:([0-9]+)");
                    Rmatcher = Rpattern.matcher(s);
                    Rmatcher.find();
                    try {
                        interval = Integer.parseInt(Rmatcher.group(1));
                    }
                    catch (Exception e) {
                        MythicLogger.error((String)("Error parsing Timer skill, invalid interval specified (must be an integer). AbstractSkill=" + s));
                        continue;
                    }
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)("AbstractSkill set on timer with interval " + interval), (Object[])new Object[0]);
                    ms.setTimerInterval(interval);
                    if (this.timerMechanics == null) {
                        this.timerMechanics = new LinkedList<SkillMechanic>();
                    }
                    this.timerMechanics.add(ms);
                    continue;
                }
                if (s.contains("~onSignal:")) {
                    String signal;
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is Signal.", (Object[])new Object[0]);
                    Rpattern = Pattern.compile("~onSignal:([a-zA-Z0-9_-]*)");
                    Rmatcher = Rpattern.matcher(s);
                    Rmatcher.find();
                    try {
                        signal = Rmatcher.group(1);
                    }
                    catch (Exception e) {
                        MythicLogger.error((String)("Error parsing Signal skill, invalid signal specified (contains invalid characters). AbstractSkill=" + s));
                        continue;
                    }
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)("AbstractSkill set on Signal with index " + signal), (Object[])new Object[0]);
                    this.saveSkill(SkillTrigger.SIGNAL, ms);
                    continue;
                }
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is NOT Timer. Assigning skill to regular skill tree...", (Object[])new Object[0]);
                this.saveSkill(ms.getTrigger(), ms);
                continue;
            }
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Base skill was not found.", (Object[])new Object[0]);
        }
    }

    private void saveSkill(SkillTrigger trigger, SkillMechanic skill) {
        if (!this.mechanics.containsKey(trigger)) {
            this.mechanics.put(trigger, new LinkedList());
        }
        this.mechanics.get(trigger).add(skill);
    }

    public boolean hasSkills(SkillTrigger trigger) {
        return this.mechanics.containsKey(trigger);
    }

    public boolean preventDropping() {
        return this.preventDropping;
    }

    public boolean destroyOnDrop() {
        return this.destroyOnDrop;
    }

    public boolean cancelHitDamage() {
        return this.cancelDamage;
    }

    public boolean usesAmmo() {
        return this.useAmmoSystem;
    }

    public Optional<MythicItem> getAmmoType() {
        return this.ammoType;
    }

    public int getAmmoClipSize() {
        return this.ammoClipSize;
    }

    public int getAmmoPerItem() {
        return this.ammoPerItem;
    }

    public int getAmmoLoreLine() {
        return this.ammoLoreLine;
    }

    public Map<SkillTrigger, Queue<SkillMechanic>> getSkills() {
        return this.mechanics;
    }

    public Optional<Queue<SkillMechanic>> getSkills(SkillTrigger trigger) {
        return Optional.ofNullable(this.mechanics.getOrDefault(trigger, null));
    }

    public String getDisplayName() {
        return this.item.getDisplayName();
    }

    public boolean getKeepOnDeath() {
        return this.keepOnDeath;
    }

    public Optional<String> getPermission() {
        return this.permission;
    }

    public boolean hasMechanics(SkillTrigger cause) {
        return this.mechanics.containsKey(cause);
    }

    public Queue<SkillMechanic> getMechanics(SkillTrigger cause) {
        return this.mechanics.get(cause);
    }

    public boolean hasTimerSkills() {
        return this.timerMechanics != null;
    }

    public Queue<SkillMechanic> getTimerSkills() {
        return this.timerMechanics;
    }

    public boolean isCancelDamage() {
        return this.cancelDamage;
    }

    public boolean isPreventDropping() {
        return this.preventDropping;
    }

    public boolean isPreventRenaming() {
        return this.preventRenaming;
    }

    public boolean isDestroyOnDrop() {
        return this.destroyOnDrop;
    }

    public boolean isDestroy() {
        return this.destroy;
    }

    public Optional<String> getItemTypeOverride() {
        return this.itemTypeOverride;
    }
}

