/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.items;

import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.items.Artifact;
import io.lumine.artifacts.items.SkillHolder;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import java.util.Queue;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.inventory.ItemStack;

public class EquippedItem
implements SkillHolder {
    private Artifact artifact;
    private ItemStack itemStack;
    private String equippedSlot;

    public EquippedItem(Artifact artifact, ItemStack item, String equippedSlot) {
        this.artifact = artifact;
        this.itemStack = item;
        this.equippedSlot = equippedSlot;
    }

    @Override
    public boolean runSkills(SkillCaster caster, SkillTrigger cause, AbstractLocation origin, AbstractEntity trigger, Consumer<SkillMetadata> transformer) {
        if (!this.artifact.hasMechanics(cause)) {
            return false;
        }
        TriggeredSkill ts = new TriggeredSkill(cause, caster, origin, trigger, this.artifact.getMechanics(cause), true, meta -> {
            meta.getVariables().putString("equip-slot", this.equippedSlot);
            meta.getVariables().putObject("equip-item", (Object)this.itemStack);
            if (transformer != null) {
                transformer.accept((SkillMetadata)meta);
            }
        }, new Pair[0]);
        return ts.getCancelled();
    }

    @Override
    public boolean hasTimerSkills() {
        return this.artifact.hasTimerSkills();
    }

    @Override
    public void runTimerSkills(SkillCaster caster, long timer) {
        if (!caster.getEntity().asPlayer().isOnline()) {
            return;
        }
        SkillMetadata data = new SkillMetadata(SkillTrigger.TIMER, caster, null);
        data.getVariables().putString("equip-slot", this.equippedSlot);
        data.getVariables().putObject("equip-item", (Object)this.itemStack);
        this.artifact.getTimerSkills().stream().forEach(skill -> {
            if ((double)timer % ((double)skill.getTimerInterval() / (double)Artifacts.inst().getConfiguration().getClockInterval()) == 0.0 && skill.usable(data)) {
                skill.execute(data);
            }
        });
    }

    @Override
    public Queue<SkillMechanic> getSkills(SkillTrigger cause) {
        return this.artifact.getMechanics(cause);
    }
}

