/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.util;

import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.enchants.MythicEnchantment;
import io.lumine.artifacts.util.RomanNumerals;
import org.bukkit.ChatColor;

public class LoreParser {
    public static String parseEnchantmentName(String text) {
        int index;
        if (!text.startsWith(ChatColor.GRAY.toString())) {
            return "";
        }
        String noColor = text.substring(2);
        int level = RomanNumerals.fromNumerals(noColor.substring((index = noColor.lastIndexOf(32)) + 1));
        return level > 0 ? noColor.substring(0, index) : noColor;
    }

    public static int parseEnchantmentLevel(String text) {
        int index = text.lastIndexOf(32);
        int level = RomanNumerals.fromNumerals(text.substring(index + 1));
        return level > 0 ? level : 1;
    }

    public static String formatEnchantment(MythicEnchantment enchantment, int level) {
        return ChatColor.GRAY + enchantment.getName() + (enchantment.getMaxLevel() > 1 ? " " + RomanNumerals.toNumerals(level) : "");
    }

    public static boolean isEnchantment(String line) {
        return Artifacts.inst().getEnchantManager().isRegistered(LoreParser.parseEnchantmentName(line));
    }
}

