/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.backbags.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagHelper;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagInventory;
import com.gmail.berndivader.mythicmobsext.items.HoldingItem;
import com.gmail.berndivader.mythicmobsext.items.WhereEnum;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MoveToBackBag
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill {
    int backbag_slot;
    WhereEnum what;
    boolean override;
    boolean tag_where;
    PlaceholderString bag_name;
    String meta_name;
    String slot;
    HoldingItem holding;

    public MoveToBackBag(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.what = WhereEnum.getWhere(mlc.getString("what", "head"));
        this.slot = mlc.getString("slot", "-1");
        this.backbag_slot = mlc.getInteger("bagslot", -1);
        this.override = mlc.getBoolean("override", true);
        this.tag_where = mlc.getBoolean("tag", false);
        this.meta_name = mlc.getString("meta", "");
        this.bag_name = mlc.getPlaceholderString(new String[]{"title", "name"}, BackBagHelper.str_name, new String[0]);
        this.holding = new HoldingItem();
        this.holding.setWhere(this.what);
        this.holding.setSlot(this.slot);
    }

    public boolean cast(SkillMetadata data) {
        return this.castAtEntity(data, data.getCaster().getEntity());
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_entity) {
        HoldingItem holding;
        if (abstract_entity.isLiving() && BackBagHelper.hasBackBag(abstract_entity.getUniqueId()) && (holding = this.holding.clone()) != null) {
            holding.parseSlot(data, abstract_entity);
            LivingEntity holder = (LivingEntity)abstract_entity.getBukkitEntity();
            BackBagInventory bag = BackBagHelper.getBagInventory(holder.getUniqueId(), this.bag_name.get((PlaceholderMeta)data, abstract_entity));
            if (bag == null) {
                return false;
            }
            Inventory inventory = bag.getInventory();
            List<ItemStack> stack = HoldingItem.getContents(holding, holder);
            for (int i1 = 0; i1 < stack.size(); ++i1) {
                int tmp_slot;
                ItemStack old_item = stack.get(i1);
                if (old_item == null) continue;
                ItemStack new_item = old_item.clone();
                if (this.tag_where) {
                    HoldingItem.tagWhere(holding, new_item);
                }
                int n = tmp_slot = this.backbag_slot <= inventory.getSize() ? this.backbag_slot : inventory.getSize();
                if (this.backbag_slot == -1) {
                    tmp_slot = inventory.firstEmpty();
                    if (tmp_slot <= -1) continue;
                    inventory.addItem(new ItemStack[]{new_item});
                    MoveToBackBag.setMetaVariable(old_item, holder, this.meta_name, tmp_slot);
                    continue;
                }
                if (this.override) {
                    inventory.setItem(tmp_slot, new_item);
                    MoveToBackBag.setMetaVariable(old_item, holder, this.meta_name, tmp_slot);
                    continue;
                }
                if (inventory.getItem(tmp_slot) != null && inventory.getItem(tmp_slot).getType() != Material.AIR) continue;
                inventory.setItem(tmp_slot, new_item);
                MoveToBackBag.setMetaVariable(old_item, holder, this.meta_name, tmp_slot);
            }
        }
        return true;
    }

    static void setMetaVariable(ItemStack old_item, LivingEntity holder, String meta_name, int backbag_slot) {
        old_item.setAmount(0);
        old_item.setType(Material.AIR);
        if (meta_name.length() > 0) {
            holder.setMetadata(meta_name, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)backbag_slot));
        }
    }
}

